/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.APContext;
import io.avaje.jsonb.generator.BeanReader;
import io.avaje.jsonb.generator.ClassReader;
import io.avaje.jsonb.generator.ComponentMetaData;
import io.avaje.jsonb.generator.ComponentReader;
import io.avaje.jsonb.generator.CreatorPrism;
import io.avaje.jsonb.generator.ImportPrism;
import io.avaje.jsonb.generator.ImportsPrism;
import io.avaje.jsonb.generator.MixInPrism;
import io.avaje.jsonb.generator.ProcessingContext;
import io.avaje.jsonb.generator.SimpleAdapterWriter;
import io.avaje.jsonb.generator.SimpleComponentWriter;
import io.avaje.jsonb.generator.UType;
import io.avaje.jsonb.generator.Util;
import io.avaje.jsonb.generator.ValueReader;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.FileObject;

@SupportedAnnotationTypes(value={"io.avaje.jsonb.CustomAdapter", "io.avaje.jsonb.Json", "io.avaje.jsonb.Json.Import", "io.avaje.jsonb.Json.Import.Imports", "io.avaje.jsonb.Json.MixIn", "io.avaje.jsonb.Json.Value", "io.avaje.spi.ServiceProvider"})
public final class JsonbProcessor
extends AbstractProcessor {
    private final Set<String> writtenTypes = new HashSet<String>();
    private final Map<String, ComponentMetaData> privateMetaData = new HashMap<String, ComponentMetaData>();
    private final ComponentMetaData metaData = new ComponentMetaData();
    private final List<BeanReader> allReaders = new ArrayList<BeanReader>();
    private final Set<String> sourceTypes = new HashSet<String>();
    private final Set<String> mixInImports = new HashSet<String>();
    private final Set<String> valueElements = new HashSet<String>();
    private SimpleComponentWriter componentWriter;
    private boolean readModuleInfo;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        ProcessingContext.init(processingEnv);
        this.componentWriter = new SimpleComponentWriter(this.metaData);
        try {
            Path file = APContext.getBuildResource("avaje-processors.txt");
            StringBuilder addition = new StringBuilder();
            if (file.toFile().exists()) {
                String result = Stream.concat(Files.lines(file), Stream.of("avaje-jsonb-generator")).distinct().collect(Collectors.joining("\n"));
                addition.append(result);
            } else {
                addition.append("avaje-jsonb-generator");
            }
            Files.writeString(file, (CharSequence)addition, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readModule() {
        if (this.readModuleInfo) {
            return;
        }
        this.readModuleInfo = true;
        new ComponentReader(this.metaData, this.privateMetaData).read();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        if (round.errorRaised()) {
            return false;
        }
        APContext.setProjectModuleElement(annotations, round);
        this.readModule();
        this.getElements(round, "io.avaje.jsonb.Json.Value").ifPresent(this::writeValueAdapters);
        this.getElements(round, "io.avaje.jsonb.Json").ifPresent(this::writeAdapters);
        this.getElements(round, "io.avaje.jsonb.Json.MixIn").ifPresent(this::writeAdaptersForMixInTypes);
        this.getElements(round, "io.avaje.jsonb.Json.Import.Imports").ifPresent(this::writeAdaptersForImportedList);
        this.getElements(round, "io.avaje.jsonb.Json.Import").ifPresent(this::writeAdaptersForImported);
        this.getElements(round, "io.avaje.jsonb.CustomAdapter").ifPresent(this::registerCustomAdapters);
        this.getElements(round, "io.avaje.spi.ServiceProvider").ifPresent(this::registerSPI);
        this.metaData.fullName(false);
        this.cascadeTypes();
        this.writeComponent(round.processingOver());
        return false;
    }

    private Optional<? extends Set<? extends Element>> getElements(RoundEnvironment round, String name) {
        return Optional.ofNullable(APContext.typeElement(name)).map(round::getElementsAnnotatedWith);
    }

    private void registerCustomAdapters(Set<? extends Element> elements) {
        for (TypeElement typeElement : ElementFilter.typesIn(elements)) {
            boolean pkgPrivate = !typeElement.getModifiers().contains((Object)Modifier.PUBLIC);
            ComponentMetaData meta = pkgPrivate ? this.pkgPrivateMetaData(typeElement) : this.metaData;
            String type = typeElement.getQualifiedName().toString();
            if (JsonbProcessor.isGenericJsonAdapter(typeElement)) {
                ElementFilter.fieldsIn(typeElement.getEnclosedElements()).stream().filter(JsonbProcessor.isStaticFactory()).findFirst().ifPresentOrElse(x -> {}, () -> APContext.logError(typeElement, "Generic adapters require a public static AdapterFactory FACTORY field", new Object[0]));
                meta.addFactory(type);
                continue;
            }
            ElementFilter.constructorsIn(typeElement.getEnclosedElements()).stream().filter(m -> m.getModifiers().contains((Object)Modifier.PUBLIC)).filter(m -> m.getParameters().size() == 1).map(m -> m.getParameters().get(0).asType().toString()).map(Util::trimAnnotations).filter("io.avaje.jsonb.Jsonb"::equals).findAny().ifPresentOrElse(x -> {}, () -> APContext.logNote(typeElement, "Non-Generic adapters should have a public constructor with a single Jsonb parameter", new Object[0]));
            meta.add(type);
        }
    }

    private ComponentMetaData pkgPrivateMetaData(TypeElement typeElement) {
        String packageName = APContext.elements().getPackageOf(typeElement).getQualifiedName().toString();
        return this.privateMetaData.computeIfAbsent(packageName, k -> new ComponentMetaData());
    }

    private static boolean isGenericJsonAdapter(TypeElement typeElement) {
        return typeElement.getInterfaces().stream().map(UType::parse).filter(u -> u.full().contains("JsonAdapter")).anyMatch(u -> u.param0().isGeneric());
    }

    private static Predicate<VariableElement> isStaticFactory() {
        return v -> v.getModifiers().contains((Object)Modifier.STATIC) && "FACTORY".equals(v.getSimpleName().toString());
    }

    private void writeValueAdapters(Set<? extends Element> elements) {
        for (ExecutableElement element : ElementFilter.methodsIn(elements)) {
            TypeElement typeElement = (TypeElement)element.getEnclosingElement();
            this.validateValue(element, typeElement);
            this.writeAdapter(typeElement, new ValueReader(typeElement, element));
        }
    }

    private void validateValue(ExecutableElement element, TypeElement typeElement) {
        if (!this.valueElements.add(typeElement.asType().toString())) {
            APContext.logError(typeElement, "@Json.Value can only be used once on a given type", new Object[0]);
        } else if (!element.getParameters().isEmpty()) {
            APContext.logError(element, "@Json.Value can only be used on methods with no parameters", new Object[0]);
        }
        if (typeElement.getKind() == ElementKind.ENUM) {
            return;
        }
        String returnType = Util.trimAnnotations(element.getReturnType().toString());
        Stream<ExecutableElement> methods = ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().filter(CreatorPrism::isPresent);
        Stream constructors = ElementFilter.constructorsIn(typeElement.getEnclosedElements()).stream();
        if (Stream.concat(methods, constructors).filter(s -> s.getParameters().size() == 1).map(s -> s.getParameters().get(0).asType().toString()).map(Util::trimAnnotations).noneMatch(returnType::equals)) {
            APContext.logError(typeElement, "Missing constructor or @Json.Creator factory method with signature %s(%s value)", Util.shortName(typeElement.getQualifiedName().toString()), Util.shortName(returnType));
        }
    }

    private void cascadeTypes() {
        while (!this.allReaders.isEmpty()) {
            this.cascadeTypesInner();
        }
    }

    private void cascadeTypesInner() {
        ArrayList<BeanReader> copy = new ArrayList<BeanReader>(this.allReaders);
        this.allReaders.clear();
        TreeSet<String> extraTypes = new TreeSet<String>();
        for (BeanReader reader : copy) {
            reader.cascadeTypes(extraTypes);
        }
        for (String type : extraTypes) {
            TypeElement element;
            if (this.ignoreType(type) || (element = APContext.typeElement(type)) == null || !this.cascadeElement(element)) continue;
            this.writeAdapterForType(element);
        }
    }

    private boolean cascadeElement(TypeElement element) {
        return element.getKind() != ElementKind.ENUM && !this.writtenTypes.contains(element.toString());
    }

    private boolean ignoreType(String type) {
        return type.indexOf(46) == -1 || type.startsWith("java.") || type.startsWith("javax.") || this.sourceTypes.contains(type);
    }

    private void writeAdaptersForMixInTypes(Set<? extends Element> mixInElements) {
        for (Element element : mixInElements) {
            TypeMirror mirror = MixInPrism.getInstanceOn(element).value();
            String importType = mirror.toString();
            TypeElement element2 = APContext.asTypeElement(mirror);
            this.mixInImports.add(importType);
            this.writeAdapterForMixInType(element2, APContext.typeElement(element.asType().toString()));
        }
    }

    private void writeAdaptersForImportedList(Set<? extends Element> imported) {
        imported.stream().flatMap(e -> ImportsPrism.getInstanceOn(e).value().stream()).forEach(this::addImported);
    }

    private void writeAdaptersForImported(Set<? extends Element> importedElements) {
        importedElements.stream().flatMap(e -> ImportPrism.getAllInstancesOn(e).stream().peek(p -> ProcessingContext.addImportedPrism(p, e))).forEach(this::addImported);
    }

    private void addImported(ImportPrism importPrism) {
        for (TypeMirror importType : importPrism.value()) {
            if (this.mixInImports.contains(importType.toString())) continue;
            this.writeAdapterForImportedType(APContext.asTypeElement(importType), JsonbProcessor.implementationType(importPrism));
        }
    }

    private static TypeElement implementationType(ImportPrism importPrism) {
        TypeMirror implementationType = importPrism.implementation();
        if (!"java.lang.Void".equals(implementationType.toString())) {
            return APContext.asTypeElement(implementationType);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeComponent(boolean processingOver) {
        if (processingOver) {
            try {
                if (!this.metaData.isEmpty()) {
                    this.componentWriter.initialise(false);
                    this.componentWriter.write();
                }
                for (ComponentMetaData meta : this.privateMetaData.values()) {
                    if (meta.isEmpty()) continue;
                    SimpleComponentWriter writer = new SimpleComponentWriter(meta);
                    writer.initialise(true);
                    writer.write();
                }
                this.writeMetaInf();
                ProcessingContext.validateModule();
            }
            catch (IOException e) {
                APContext.logError("Error writing component", e);
            }
            finally {
                ProcessingContext.clear();
            }
        }
    }

    private void writeAdapters(Set<? extends Element> beans) {
        for (Element element : beans) {
            if (!(element instanceof TypeElement)) {
                APContext.logError("unexpected type [" + String.valueOf(element) + "]", new Object[0]);
                continue;
            }
            this.writeAdapterForType((TypeElement)element);
        }
    }

    private void writeAdapterForType(TypeElement typeElement) {
        if (this.valueElements.contains(typeElement.toString())) {
            return;
        }
        this.writeAdapter(typeElement, new ClassReader(typeElement, ""));
    }

    private void writeAdapterForImportedType(TypeElement importedType, TypeElement implementationType) {
        ClassReader beanReader = new ClassReader(importedType, "@Json.Import of ");
        if (implementationType != null) {
            beanReader.setImplementationType(implementationType);
        }
        this.writeAdapter(importedType, beanReader);
    }

    private void writeAdapterForMixInType(TypeElement typeElement, TypeElement mixin) {
        ClassReader beanReader = new ClassReader(typeElement, mixin, "@Json.Mixin of ");
        this.writeAdapter(typeElement, beanReader);
    }

    private void writeAdapter(TypeElement typeElement, BeanReader beanReader) {
        if (!this.writtenTypes.add(typeElement.toString())) {
            return;
        }
        beanReader.read();
        if (beanReader.nonAccessibleField()) {
            if (beanReader.hasJsonAnnotation()) {
                APContext.logError("Error JsonAdapter due to nonAccessibleField for %s ", beanReader);
            }
            APContext.logNote("Skipped writing JsonAdapter for %s due to non accessible fields", beanReader);
            return;
        }
        try {
            SimpleAdapterWriter beanWriter = new SimpleAdapterWriter(beanReader);
            if (beanReader.isPkgPrivate()) {
                this.writeMeta(beanWriter, this.pkgPrivateMetaData(typeElement));
            } else {
                this.writeMeta(beanWriter, this.metaData);
            }
            beanWriter.write();
            this.allReaders.add(beanReader);
            this.sourceTypes.add(typeElement.getSimpleName().toString());
        }
        catch (IOException e) {
            APContext.logError("Error writing JsonAdapter for %s %s", beanReader, e);
        }
    }

    private void writeMeta(SimpleAdapterWriter beanWriter, ComponentMetaData meta) {
        meta.add(beanWriter.fullName());
        if (beanWriter.hasGenericFactory()) {
            meta.addFactory(beanWriter.fullName());
        }
    }

    private void registerSPI(Set<? extends Element> beans) {
        ElementFilter.typesIn(beans).stream().filter(this::isExtension).map(TypeElement::getQualifiedName).map(Object::toString).forEach(ProcessingContext::addJsonSpi);
    }

    private boolean isExtension(TypeElement te) {
        return APContext.isAssignable(te, "io.avaje.jsonb.spi.JsonbExtension");
    }

    private void writeMetaInf() throws IOException {
        Set<String> services = ProcessingContext.readExistingMetaInfServices();
        FileObject fileObject = ProcessingContext.createMetaInfWriterFor("META-INF/services/io.avaje.jsonb.spi.JsonbExtension");
        if (fileObject != null) {
            Writer writer = fileObject.openWriter();
            writer.write(String.join((CharSequence)"\n", services));
            writer.close();
        }
    }
}

