/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

final class JsonFactoryPrism {
    private final List<TypeMirror> _value;
    public static final String PRISM_TYPE = "io.avaje.jsonb.spi.MetaData.JsonFactory";
    final Values values;
    final boolean isValid;
    final AnnotationMirror mirror;
    private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    static boolean isInstance(AnnotationMirror mirror) {
        return JsonFactoryPrism.getInstance(mirror) != null;
    }

    static boolean isPresent(Element element) {
        return JsonFactoryPrism.getInstanceOn(element) != null;
    }

    static JsonFactoryPrism getInstanceOn(Element element) {
        AnnotationMirror mirror = JsonFactoryPrism.getMirror(element);
        if (mirror == null) {
            return null;
        }
        return JsonFactoryPrism.getInstance(mirror);
    }

    static Optional<JsonFactoryPrism> getOptionalOn(Element element) {
        AnnotationMirror mirror = JsonFactoryPrism.getMirror(element);
        if (mirror == null) {
            return Optional.empty();
        }
        return JsonFactoryPrism.getOptional(mirror);
    }

    static List<JsonFactoryPrism> getAllOnMetaAnnotations(Element element) {
        if (element == null || element.getAnnotationMirrors().isEmpty()) {
            return List.of();
        }
        return JsonFactoryPrism.getAllOnMetaAnnotations(element, new HashSet<String>()).collect(Collectors.toList());
    }

    private static Stream<JsonFactoryPrism> getAllOnMetaAnnotations(Element element, Set<String> seen) {
        if (element == null || element.getAnnotationMirrors().isEmpty()) {
            return Stream.of(new JsonFactoryPrism[0]);
        }
        return element.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).filter(t -> seen.add(t.toString())).map(DeclaredType::asElement).flatMap(e -> Stream.concat(JsonFactoryPrism.getAllOnMetaAnnotations(e, seen), JsonFactoryPrism.getMirrors(element).map(JsonFactoryPrism::getInstance)));
    }

    static JsonFactoryPrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new JsonFactoryPrism(mirror);
    }

    static Optional<JsonFactoryPrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new JsonFactoryPrism(mirror));
    }

    private JsonFactoryPrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._value = this.getArrayValues("value", TypeMirror.class);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public List<TypeMirror> value() {
        return this._value;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = JsonFactoryPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        List<T> result = JsonFactoryPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!PRISM_TYPE.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static Stream<? extends AnnotationMirror> getMirrors(Element target) {
        return target.getAnnotationMirrors().stream().filter(m -> PRISM_TYPE.contentEquals(((TypeElement)m.getAnnotationType().asElement()).getQualifiedName()));
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return List.of();
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : JsonFactoryPrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return List.of();
            }
            return result;
        }
        return List.of();
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }

    static final class Values {
        private final Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        AnnotationValue value() {
            return this.values.get("value");
        }
    }
}

