/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class IgnorePrism {
    private final Boolean _serialize;
    private final Boolean _deserialize;
    public static final String PRISM_TYPE = "io.avaje.jsonb.Json.Ignore";
    final Values values;
    final boolean isValid;
    final AnnotationMirror mirror;
    private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    static boolean isInstance(AnnotationMirror mirror) {
        return IgnorePrism.getInstance(mirror) != null;
    }

    static boolean isPresent(Element element) {
        return IgnorePrism.getInstanceOn(element) != null;
    }

    static IgnorePrism getInstanceOn(Element element) {
        AnnotationMirror mirror = IgnorePrism.getMirror(element);
        if (mirror == null) {
            return null;
        }
        return IgnorePrism.getInstance(mirror);
    }

    static Optional<IgnorePrism> getOptionalOn(Element element) {
        AnnotationMirror mirror = IgnorePrism.getMirror(element);
        if (mirror == null) {
            return Optional.empty();
        }
        return IgnorePrism.getOptional(mirror);
    }

    static IgnorePrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new IgnorePrism(mirror);
    }

    static Optional<IgnorePrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new IgnorePrism(mirror));
    }

    private IgnorePrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._serialize = this.getValue("serialize", Boolean.class);
        this._deserialize = this.getValue("deserialize", Boolean.class);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public Boolean serialize() {
        return this._serialize;
    }

    public Boolean deserialize() {
        return this._deserialize;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = IgnorePrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!PRISM_TYPE.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    static final class Values {
        private final Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        AnnotationValue serialize() {
            return this.values.get("serialize");
        }

        AnnotationValue deserialize() {
            return this.values.get("deserialize");
        }
    }
}

