/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.APContext;
import io.avaje.jsonb.generator.ComponentMetaData;
import io.avaje.jsonb.generator.JsonFactoryPrism;
import io.avaje.jsonb.generator.MetaDataPrism;
import io.avaje.jsonb.generator.ProcessingContext;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class ComponentReader {
    private final ComponentMetaData componentMetaData;
    private final Map<String, ComponentMetaData> privateMetaData;

    ComponentReader(ComponentMetaData metaData, Map<String, ComponentMetaData> privateMetaData) {
        this.componentMetaData = metaData;
        this.privateMetaData = privateMetaData;
    }

    void read() {
        for (String fqn : ProcessingContext.readExistingMetaInfServices()) {
            TypeElement moduleType = APContext.typeElement(fqn);
            if (!ComponentReader.isGeneratedComponent(moduleType)) continue;
            if (ComponentReader.hasPublicComponents(moduleType)) {
                this.componentMetaData.setFullName(fqn);
                ComponentReader.readMetaData(moduleType, this.componentMetaData);
                continue;
            }
            String packageName = APContext.elements().getPackageOf(moduleType).getQualifiedName().toString();
            ComponentMetaData meta = this.privateMetaData.computeIfAbsent(packageName, k -> new ComponentMetaData());
            ComponentReader.readMetaData(moduleType, meta);
        }
    }

    private static boolean hasPublicComponents(TypeElement moduleType) {
        return MetaDataPrism.getInstanceOn(moduleType).value().stream().map(APContext::asTypeElement).findFirst().map(ComponentReader::hasPublicModifier).orElse(ComponentReader.hasPublicJsonFactory(moduleType));
    }

    private static Boolean hasPublicJsonFactory(TypeElement moduleType) {
        return JsonFactoryPrism.getInstanceOn(moduleType).value().stream().map(APContext::asTypeElement).findFirst().map(ComponentReader::hasPublicModifier).orElse(false);
    }

    private static boolean hasPublicModifier(TypeElement a) {
        return a.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    private static boolean isGeneratedComponent(TypeElement moduleType) {
        return moduleType != null && "io.avaje.jsonb.spi.GeneratedComponent".equals(moduleType.getSuperclass().toString());
    }

    private static void readMetaData(TypeElement moduleType, ComponentMetaData meta) {
        for (AnnotationMirror annotationMirror : moduleType.getAnnotationMirrors()) {
            JsonFactoryPrism metaDataFactory;
            MetaDataPrism metaData = MetaDataPrism.getInstance(annotationMirror);
            if (metaData != null) {
                metaData.value().stream().map(TypeMirror::toString).forEach(meta::add);
            }
            if ((metaDataFactory = JsonFactoryPrism.getInstance(annotationMirror)) == null) continue;
            metaDataFactory.value().stream().map(TypeMirror::toString).forEach(meta::addFactory);
        }
    }
}

