/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.APContext;
import io.avaje.jsonb.generator.BeanReader;
import io.avaje.jsonb.generator.ProcessingContext;
import io.avaje.jsonb.generator.Util;
import javax.lang.model.element.TypeElement;

final class AdapterName {
    final String shortName;
    final String adapterPackage;
    final String fullName;

    AdapterName(BeanReader beanReader) {
        String originPackage = APContext.elements().getPackageOf(beanReader.beanType()).getQualifiedName().toString();
        String name = this.shortName(beanReader.beanType());
        this.shortName = name.substring(0, name.length() - 1);
        this.adapterPackage = beanReader.isPkgPrivate() ? originPackage : ("".equals(originPackage) ? "jsonb" : (ProcessingContext.isImported(beanReader.beanType()) ? originPackage + ".jsonb" : originPackage));
        this.fullName = this.adapterPackage + "." + this.shortName + "JsonAdapter";
    }

    private String shortName(TypeElement origin) {
        StringBuilder sb = new StringBuilder();
        if (origin.getNestingKind().isNested()) {
            sb.append(this.shortName((TypeElement)origin.getEnclosingElement()));
        }
        return sb.append(Util.shortName(origin.getSimpleName().toString())).append("$").toString();
    }

    String shortName() {
        return this.shortName;
    }

    String adapterPackage() {
        return this.adapterPackage;
    }

    String fullName() {
        return this.fullName;
    }
}

