/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.APContext;
import io.avaje.jsonb.generator.CustomAdapterPrism;
import io.avaje.jsonb.generator.TopPackage;
import io.avaje.jsonb.generator.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Predicate;

final class ComponentMetaData {
    private final List<String> allTypes = new ArrayList<String>();
    private final List<String> factoryTypes = new ArrayList<String>();
    private final List<String> withTypes = new ArrayList<String>();
    private String fullName;

    ComponentMetaData() {
    }

    public String toString() {
        return this.allTypes.toString();
    }

    void initialiseFullName() {
        this.fullName();
    }

    boolean contains(String type) {
        return this.allTypes.contains(type);
    }

    void add(String type) {
        Optional.ofNullable(APContext.typeElement(type)).flatMap(CustomAdapterPrism::getOptionalOn).filter(Predicate.not(CustomAdapterPrism::global)).ifPresentOrElse(p -> this.withTypes.add(type), () -> this.allTypes.add(type));
    }

    void addFactory(String fullName) {
        this.factoryTypes.add(fullName);
    }

    public void addWithType(String type) {
        this.withTypes.add(type);
    }

    void setFullName(String fullName) {
        this.fullName = fullName;
    }

    String fullName() {
        if (this.fullName == null) {
            Object topPackage = TopPackage.of(this.allTypes);
            if (!((String)topPackage).endsWith(".jsonb")) {
                topPackage = (String)topPackage + ".jsonb";
            }
            this.fullName = (String)topPackage + ".GeneratedJsonComponent";
        }
        return this.fullName;
    }

    String packageName() {
        return Util.packageOf(this.fullName());
    }

    List<String> all() {
        return this.allTypes;
    }

    List<String> allFactories() {
        return this.factoryTypes;
    }

    List<String> withTypes() {
        return this.withTypes;
    }

    Collection<String> allImports() {
        TreeSet<String> packageImports = new TreeSet<String>();
        for (String adapterFullName : this.allTypes) {
            packageImports.add(adapterFullName);
            String className = Util.baseTypeOfAdapter(adapterFullName);
            int $index = className.indexOf("$");
            packageImports.add($index != -1 ? className.substring(0, $index) : className);
        }
        packageImports.addAll(this.factoryTypes);
        packageImports.addAll(this.withTypes);
        return packageImports;
    }

    public boolean isEmpty() {
        return this.allTypes.isEmpty() && this.factoryTypes.isEmpty();
    }
}

