/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.APContext;
import io.avaje.jsonb.generator.CreatorPrism;
import io.avaje.jsonb.generator.FieldProperty;
import io.avaje.jsonb.generator.FieldReader;
import io.avaje.jsonb.generator.GenericType;
import io.avaje.jsonb.generator.JsonPrism;
import io.avaje.jsonb.generator.MethodProperty;
import io.avaje.jsonb.generator.MethodReader;
import io.avaje.jsonb.generator.NamingConvention;
import io.avaje.jsonb.generator.ProcessingContext;
import io.avaje.jsonb.generator.PropertyPrism;
import io.avaje.jsonb.generator.TypeSubTypeMeta;
import io.avaje.jsonb.generator.TypeSubTypeReader;
import io.avaje.jsonb.generator.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

final class TypeReader {
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String JAVA_LANG_THROWABLE = "java.lang.Throwable";
    private static final Set<String> THROWABLE_INCLUDES = Set.of("getMessage", "getCause", "getStackTrace", "getSuppressed");
    private static final Set<String> THROWABLE_FIELDS = Set.of("detailMessage", "suppressedExceptions", "stackTrace");
    private final List<MethodReader> publicConstructors = new ArrayList<MethodReader>();
    private final List<FieldReader> allFields = new ArrayList<FieldReader>();
    private final Map<String, FieldReader> allFieldMap = new HashMap<String, FieldReader>();
    private final Map<String, MethodReader> maybeSetterMethods = new LinkedHashMap<String, MethodReader>();
    private final Map<String, MethodReader> maybeGetterMethods = new LinkedHashMap<String, MethodReader>();
    private final Map<String, MethodReader> allGetterMethods = new LinkedHashMap<String, MethodReader>();
    private final Map<String, MethodReader> allSetterMethods = new LinkedHashMap<String, MethodReader>();
    private final TypeSubTypeReader subTypes;
    private final TypeElement baseType;
    private final List<String> genericTypeParams;
    private final NamingConvention namingConvention;
    private final boolean hasJsonAnnotation;
    private final String errorContext;
    private MethodReader constructor;
    private boolean defaultPublicConstructor;
    private final Map<String, MethodReader.MethodParam> constructorParamMap = new LinkedHashMap<String, MethodReader.MethodParam>();
    private TypeSubTypeMeta currentSubType;
    private boolean nonAccessibleField;
    private final Map<String, Element> mixInFields;
    private final String typePropertyKey;
    private final Map<String, Integer> frequencyMap = new HashMap<String, Integer>();
    private final List<MethodProperty> methodProperties = new ArrayList<MethodProperty>();
    private boolean optional;
    private boolean extendsThrowable;
    private final boolean hasJsonCreator;

    TypeReader(String errorContext, TypeElement baseType, TypeElement mixInType, NamingConvention namingConvention, String typePropertyKey) {
        this.errorContext = errorContext;
        this.baseType = baseType;
        this.genericTypeParams = this.initTypeParams(baseType);
        Optional<Object> jsonCreator = Optional.empty();
        if (mixInType == null) {
            this.mixInFields = new HashMap<String, Element>();
        } else {
            jsonCreator = ElementFilter.methodsIn(mixInType.getEnclosedElements()).stream().filter(CreatorPrism::isPresent).findFirst();
            this.mixInFields = mixInType.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.FIELD).collect(Collectors.toMap(e -> e.getSimpleName().toString(), e -> e));
        }
        this.namingConvention = namingConvention;
        this.hasJsonAnnotation = JsonPrism.isPresent(baseType) || ProcessingContext.importedJson(baseType).isPresent();
        this.subTypes = new TypeSubTypeReader(baseType);
        this.typePropertyKey = typePropertyKey;
        jsonCreator = jsonCreator.or(TypeReader.baseJsonCreator(baseType));
        this.constructor = jsonCreator.map(this::readJsonCreator).orElse(null);
        this.hasJsonCreator = jsonCreator.isPresent();
    }

    private MethodReader readJsonCreator(ExecutableElement ex) {
        Set<Modifier> mods = ex.getModifiers();
        if (ex.getKind() != ElementKind.CONSTRUCTOR && !mods.contains((Object)Modifier.STATIC) && Util.isPublic(ex)) {
            APContext.logError(ex, "@Json.Creator can only be placed on constructors and static factory methods", new Object[0]);
        }
        return new MethodReader(ex).read();
    }

    private static Supplier<Optional<? extends ExecutableElement>> baseJsonCreator(TypeElement baseType) {
        return () -> baseType.getEnclosedElements().stream().filter(CreatorPrism::isPresent).map(ExecutableElement.class::cast).findFirst();
    }

    private List<String> initTypeParams(TypeElement beanType) {
        if (beanType.getTypeParameters().isEmpty()) {
            return Collections.emptyList();
        }
        return beanType.getTypeParameters().stream().map(Object::toString).collect(Collectors.toList());
    }

    int genericTypeParamsCount() {
        return this.genericTypeParams.size();
    }

    void read(TypeElement type) {
        ArrayList<FieldReader> localFields = new ArrayList<FieldReader>();
        for (Element element : type.getEnclosedElements()) {
            switch (element.getKind()) {
                case CONSTRUCTOR: {
                    this.readConstructor(element, type);
                    break;
                }
                case FIELD: {
                    this.readField(element, localFields);
                    break;
                }
                case METHOD: {
                    this.readMethod(element, localFields);
                }
            }
        }
        if (this.hasJsonCreator) {
            for (MethodReader.MethodParam methodParam : this.constructor.getParams()) {
                String name = methodParam.name();
                VariableElement element = methodParam.element();
                Optional<FieldReader> matchingField = localFields.stream().filter(f -> f.propertyName().equals(name) || f.fieldName().equals(name)).findFirst();
                matchingField.ifPresentOrElse(f -> f.readParam(element), () -> this.readField(element, localFields));
            }
        }
        if (this.currentSubType == null && type != this.baseType) {
            this.allFields.addAll(0, localFields);
            for (FieldReader fieldReader : localFields) {
                this.allFieldMap.put(fieldReader.fieldName() + fieldReader.adapterShortType(), fieldReader);
            }
        } else {
            for (FieldReader fieldReader : localFields) {
                FieldReader commonField = this.allFieldMap.get(fieldReader.fieldName() + fieldReader.adapterShortType());
                if (commonField == null) {
                    this.allFields.add(fieldReader);
                    this.allFieldMap.put(fieldReader.fieldName() + fieldReader.adapterShortType(), fieldReader);
                } else {
                    commonField.addSubType(this.currentSubType);
                }
                if (commonField != null || this.currentSubType == null) continue;
                fieldReader.setSubTypeField();
            }
        }
    }

    private void readField(Element element, List<FieldReader> localFields) {
        Element mixInField = this.mixInFields.get(element.getSimpleName().toString());
        if (mixInField != null && APContext.types().isSameType(mixInField.asType(), element.asType())) {
            HashSet<Modifier> mixinModifiers = new HashSet<Modifier>(mixInField.getModifiers());
            HashSet<Modifier> modifiers = new HashSet<Modifier>(mixInField.getModifiers());
            Arrays.stream(Modifier.values()).filter(m -> m != Modifier.PRIVATE || m != Modifier.PROTECTED || m != Modifier.PUBLIC).forEach(m -> {
                modifiers.remove(m);
                mixinModifiers.remove(m);
            });
            if (!modifiers.equals(mixinModifiers)) {
                APContext.logError(mixInField, "mixIn fields must have the same modifiers as the target class", new Object[0]);
            }
            element = mixInField;
        }
        if (element.asType().toString().contains("java.util.Optional")) {
            this.optional = true;
        }
        if (this.includeField(element)) {
            Integer frequency = this.frequency(element.getSimpleName().toString());
            localFields.add(new FieldReader(element, this.namingConvention, this.currentSubType, this.genericTypeParams, frequency, this.hasJsonCreator));
        }
    }

    private Integer frequency(String key) {
        return this.frequencyMap.compute(key, (k, v) -> v == null ? 0 : v + 1);
    }

    private boolean includeField(Element element) {
        if (this.extendsThrowable) {
            return !element.getModifiers().contains((Object)Modifier.TRANSIENT) && !element.getModifiers().contains((Object)Modifier.STATIC) && !THROWABLE_FIELDS.contains(element.getSimpleName().toString());
        }
        return !element.getModifiers().contains((Object)Modifier.TRANSIENT) && !element.getModifiers().contains((Object)Modifier.STATIC);
    }

    private void readConstructor(Element element, TypeElement type) {
        if (this.constructor != null) {
            return;
        }
        if (this.currentSubType != null ? this.currentSubType.element() != type : type != this.baseType) {
            return;
        }
        ExecutableElement ex = (ExecutableElement)element;
        MethodReader methodReader = new MethodReader(ex).read();
        if (methodReader.isPublic() || this.hasSubTypes() && methodReader.isProtected()) {
            if (this.currentSubType != null) {
                this.currentSubType.addConstructor(methodReader);
            } else {
                if (methodReader.getParams().isEmpty()) {
                    this.defaultPublicConstructor = true;
                }
                this.publicConstructors.add(methodReader);
            }
        }
    }

    private void readMethod(Element element, List<FieldReader> localFields) {
        ExecutableElement methodElement = (ExecutableElement)element;
        if (this.checkMethod2(methodElement)) {
            TypeMirror returnType;
            List<? extends VariableElement> parameters = methodElement.getParameters();
            String methodKey = methodElement.getSimpleName().toString();
            MethodReader methodReader = new MethodReader(methodElement).read();
            if (parameters.size() == 1) {
                this.maybeSetterMethods.putIfAbsent(methodKey, methodReader);
                this.allSetterMethods.put(methodKey.toLowerCase(), methodReader);
            } else if (parameters.isEmpty() && !"void".equals((returnType = methodElement.getReturnType()).toString())) {
                this.maybeGetterMethods.putIfAbsent(methodKey, methodReader);
                this.allGetterMethods.put(methodKey.toLowerCase(), methodReader);
            }
        }
        PropertyPrism.getOptionalOn(methodElement).ifPresent(propertyPrism -> {
            if (!methodElement.getParameters().isEmpty()) {
                APContext.logError(this.errorContext + String.valueOf(this.baseType) + ", @Json.Property can only be placed on Getter Methods, but on %s", methodElement);
                return;
            }
            Integer frequency = this.frequency(propertyPrism.value());
            FieldReader reader = new FieldReader(element, this.namingConvention, this.currentSubType, this.genericTypeParams, frequency);
            reader.getterMethod(new MethodReader(methodElement));
            localFields.add(reader);
        });
    }

    private boolean checkMethod2(ExecutableElement methodElement) {
        if (!Util.isPublic(methodElement)) {
            return false;
        }
        if (this.extendsThrowable) {
            return THROWABLE_INCLUDES.contains(methodElement.getSimpleName().toString());
        }
        return true;
    }

    private void matchFieldsToSetterOrConstructor() {
        for (FieldReader field : this.allFields) {
            if (!field.includeFromJson() || field.isConstructorParam()) continue;
            if (this.constructorParamMap.get(field.fieldName()) != null) {
                field.setConstructorParam();
                continue;
            }
            this.matchFieldToSetter(field);
        }
    }

    private void matchFieldToSetter(FieldReader field) {
        if (this.hasNoSetter(field)) {
            if (this.isCollectionType(field.type())) {
                field.setUseGetterAddAll();
            } else {
                APContext.logError(this.errorContext + String.valueOf(this.baseType) + ", non public field " + field.fieldName() + " with no matching setter or constructor?", new Object[0]);
            }
        }
    }

    private boolean isCollectionType(GenericType genericType) {
        String topType = genericType.topType();
        return "java.util.List".equals(topType) || "java.util.Set".equals(topType) || "java.util.Collection".equals(topType);
    }

    private boolean hasNoSetter(FieldReader field) {
        String propName = field.propertyName();
        String fieldName = field.fieldName();
        return !this.matchSetter(fieldName, field, false) && !this.matchSetter(fieldName, field, true) && !this.matchFieldToSetterByParam(fieldName, field) && !this.matchSetter(propName, field, false) && !this.matchSetter(propName, field, true) && !this.matchFieldToSetterByParam(propName, field) && !field.isPublicField() && !field.isSubTypeField();
    }

    private boolean matchFieldToSetterByParam(String fieldName, FieldReader field) {
        for (MethodReader methodReader : this.maybeSetterMethods.values()) {
            List<MethodReader.MethodParam> params = methodReader.getParams();
            MethodReader.MethodParam methodParam = params.get(0);
            if (!methodParam.name().equals(fieldName)) continue;
            field.setterMethod(methodReader);
            return true;
        }
        return false;
    }

    private boolean matchSetter(String name, FieldReader field, boolean loose) {
        MethodReader setter = this.setterLookup(name, loose);
        if (setter != null) {
            field.setterMethod(setter);
            return true;
        }
        setter = this.setterLookup(this.setterName(name), loose);
        if (setter != null) {
            field.setterMethod(setter);
            return true;
        }
        if (field.typeBooleanWithIsPrefix() && (setter = this.setterLookup(this.setterName(name.substring(2)), loose)) != null) {
            field.setterMethod(setter);
            return true;
        }
        return false;
    }

    private MethodReader setterLookup(String name, boolean loose) {
        if (loose) {
            return this.allSetterMethods.get(name.toLowerCase());
        }
        return this.maybeSetterMethods.get(name);
    }

    private void matchFieldsToGetter() {
        for (FieldReader field : this.allFields) {
            if (!field.includeToJson()) continue;
            this.matchFieldToGetter(field);
        }
    }

    private void matchFieldToGetter(FieldReader field) {
        String propName = field.propertyName();
        String fieldName = field.fieldName();
        if (!(this.matchGetter(fieldName, field, false) || this.matchGetter(fieldName, field, true) || this.matchGetter(propName, field, false) || this.matchGetter(propName, field, true) || field.isPublicField() || field.isSubTypeField())) {
            this.nonAccessibleField = true;
            if (this.hasJsonAnnotation) {
                APContext.logError(this.errorContext + String.valueOf(this.baseType) + ", non accessible field " + field.fieldName() + " with no matching getter?", new Object[0]);
            } else {
                APContext.logNote(this.errorContext + String.valueOf(this.baseType) + ", non accessible field " + field.fieldName(), new Object[0]);
            }
        }
    }

    private boolean matchGetter(String name, FieldReader field, boolean loose) {
        MethodReader getter = this.getterLookup(name, loose);
        if (getter != null) {
            field.getterMethod(getter);
            return true;
        }
        getter = this.getterLookup(this.getterName(name), loose);
        if (getter != null) {
            field.getterMethod(getter);
            return true;
        }
        getter = this.getterLookup(this.isGetterName(name), loose);
        if (getter != null) {
            field.getterMethod(getter);
            return true;
        }
        if (field.typeObjectBooleanWithIsPrefix() && (getter = this.getterLookup(this.getterName(name.substring(2)), loose)) != null) {
            field.getterMethod(getter);
            return true;
        }
        return false;
    }

    private MethodReader getterLookup(String name, boolean loose) {
        if (!loose) {
            return this.maybeGetterMethods.get(name);
        }
        return this.allGetterMethods.get(name.toLowerCase());
    }

    private String setterName(String name) {
        return "set" + Util.initCap(name);
    }

    private String getterName(String name) {
        return "get" + Util.initCap(name);
    }

    private String isGetterName(String name) {
        return "is" + Util.initCap(name);
    }

    boolean nonAccessibleField() {
        return this.nonAccessibleField;
    }

    List<FieldReader> allFields() {
        return this.allFields;
    }

    MethodReader constructor() {
        return this.constructor;
    }

    private MethodReader determineConstructor() {
        if (this.constructor != null) {
            return this.constructor;
        }
        if (this.defaultPublicConstructor && !this.allSetterMethods.isEmpty()) {
            return null;
        }
        if (this.publicConstructors.size() == 1) {
            return this.publicConstructors.get(0);
        }
        ArrayList<MethodReader> allPublic = new ArrayList<MethodReader>();
        for (MethodReader ctor : this.publicConstructors) {
            if (!ctor.isPublic()) continue;
            allPublic.add(ctor);
        }
        if (allPublic.size() == 1) {
            return (MethodReader)allPublic.get(0);
        }
        Set constructorFields = this.allFields.stream().filter(FieldReader::includeFromJson).filter(this::hasNoSetter).map(f -> f.element().asType().toString()).map(Util::trimAnnotations).collect(Collectors.toSet());
        return allPublic.stream().filter(c -> c.getParams().size() == constructorFields.size()).filter(c -> c.getParams().stream().map(p -> p.element().asType().toString()).map(Util::trimAnnotations).allMatch(constructorFields::contains)).findFirst().orElseGet(this::largest);
    }

    private MethodReader largest() {
        int argCount = 0;
        MethodReader largestConstructor = null;
        for (MethodReader ctor : this.publicConstructors) {
            int paramCount;
            if (!ctor.isPublic() || (paramCount = ctor.getParams().size()) <= argCount) continue;
            largestConstructor = ctor;
            argCount = paramCount;
        }
        return largestConstructor;
    }

    void process() {
        TypeElement superElement;
        String base = this.baseType.getQualifiedName().toString();
        if (!GenericType.isGeneric(base)) {
            this.read(this.baseType);
        }
        if ((superElement = this.superOf(this.baseType)) != null) {
            this.addSuperType(superElement);
        }
        this.readSubTypes();
        this.processCompleted();
    }

    private void readSubTypes() {
        if (this.hasSubTypes()) {
            Iterator<TypeSubTypeMeta> iterator = this.subTypes.subTypes().iterator();
            while (iterator.hasNext()) {
                TypeSubTypeMeta subType;
                this.currentSubType = subType = iterator.next();
                TypeElement element = APContext.typeElement(subType.type());
                this.currentSubType.setElement(element);
                this.addSuperType(element);
            }
        }
    }

    List<TypeSubTypeMeta> subTypes() {
        return this.subTypes.subTypes();
    }

    void processCompleted() {
        this.setFieldPositions();
        this.constructor = this.determineConstructor();
        if (this.constructor != null) {
            List<MethodReader.MethodParam> constructorParams = this.constructor.getParams();
            for (MethodReader.MethodParam param : constructorParams) {
                String name = param.name();
                Optional<FieldReader> matchingField = this.allFields.stream().filter(f -> !f.isConstructorParam()).filter(f -> f.propertyName().equals(name) || f.fieldName().equals(name)).findFirst();
                matchingField.ifPresent(FieldReader::setConstructorParam);
            }
            List<MethodReader.MethodParam> params = constructorParams;
            for (MethodReader.MethodParam param : params) {
                this.constructorParamMap.put(param.name(), param);
            }
        }
        this.matchFieldsToSetterOrConstructor();
        this.matchFieldsToGetter();
        if (this.extendsThrowable || this.allFields.isEmpty() && this.subTypes.subTypes().isEmpty()) {
            this.initReadOnlyMethods();
        }
    }

    private void setFieldPositions() {
        int offset = this.subTypes.hasSubTypes() ? 1 : 0;
        List fields = this.allFields.stream().filter(f -> !f.propertyName().equals(this.typePropertyKey)).collect(Collectors.toList());
        int size = fields.size();
        for (int pos = 0; pos < size; ++pos) {
            FieldReader field = (FieldReader)fields.get(pos);
            if (pos > 0 && ((FieldReader)fields.get(pos - 1)).propertyName().equals(field.propertyName())) {
                field.position(pos - 1);
                continue;
            }
            field.position(pos + offset);
        }
    }

    private void addSuperType(TypeElement element) {
        String type = element.getQualifiedName().toString();
        if (!JAVA_LANG_OBJECT.equals(type) && !GenericType.isGeneric(type)) {
            if (JAVA_LANG_THROWABLE.equals(type)) {
                this.extendsThrowable = true;
            }
            this.read(element);
            this.addSuperType(this.superOf(element));
        }
    }

    private TypeElement superOf(TypeElement element) {
        return APContext.asTypeElement(element.getSuperclass());
    }

    boolean hasSubTypes() {
        return this.subTypes.hasSubTypes();
    }

    public boolean hasOptional() {
        return this.optional;
    }

    public List<MethodProperty> methodProperties() {
        return this.methodProperties;
    }

    private void initReadOnlyMethods() {
        int pos = 0;
        for (MethodReader methodReader : this.maybeGetterMethods.values()) {
            FieldProperty property = new FieldProperty(methodReader);
            property.setGetterMethod(methodReader);
            property.setPosition(pos);
            ++pos;
            String name = this.initPropertyName(methodReader.getName(), property);
            String propertyName = this.namingConvention.from(name);
            this.methodProperties.add(new MethodProperty(propertyName, property));
        }
    }

    private String initPropertyName(String name, FieldProperty property) {
        if (property.typeBooleanWithIsPrefix()) {
            return Util.initLower(name.substring(2));
        }
        if (name.length() > 3 && name.startsWith("get") && Character.isUpperCase(name.charAt(3))) {
            return Util.initLower(name.substring(3));
        }
        return name;
    }

    boolean extendsThrowable() {
        return this.extendsThrowable;
    }
}

