/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.APContext;
import io.avaje.jsonb.generator.ImportPrism;
import io.avaje.jsonb.generator.JsonPrism;
import io.avaje.jsonb.generator.ModuleInfoReader;
import io.avaje.jsonb.generator.SubTypePrism;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

final class ProcessingContext {
    private static final ThreadLocal<Ctx> CTX = new ThreadLocal();

    private ProcessingContext() {
    }

    static void init(ProcessingEnvironment processingEnv) {
        APContext.init(processingEnv);
        CTX.set(new Ctx(processingEnv));
    }

    static boolean useEnhancedSwitch() {
        return APContext.jdkVersion() >= 14;
    }

    static FileObject createMetaInfWriterFor(String interfaceType) throws IOException {
        return APContext.filer().createResource(StandardLocation.CLASS_OUTPUT, "", interfaceType, new Element[0]);
    }

    static void addImportedPrism(ImportPrism prism, Element element) {
        if (!prism.subtypes().isEmpty() && prism.value().size() > 1) {
            APContext.logError(element, "subtypes cannot be used when an import annotation imports more than one class", new Object[0]);
            return;
        }
        Map<String, JsonPrism> json = ProcessingContext.CTX.get().importedJsonMap;
        Map<String, List<SubTypePrism>> subtypes = ProcessingContext.CTX.get().importedSubtypeMap;
        prism.value().forEach(m -> {
            String type = m.toString();
            json.put(type, prism.jsonSettings());
            subtypes.put(type, prism.subtypes());
        });
    }

    static Optional<JsonPrism> importedJson(TypeElement type) {
        return Optional.ofNullable(ProcessingContext.CTX.get().importedJsonMap.get(type.asType().toString()));
    }

    static boolean isImported(Element element) {
        Name moduleName = APContext.getProjectModuleElement().getQualifiedName();
        return !APContext.elements().getModuleOf(element).getQualifiedName().contentEquals(moduleName);
    }

    static List<SubTypePrism> importedSubtypes(TypeElement type) {
        return ProcessingContext.CTX.get().importedSubtypeMap.getOrDefault(type.asType().toString(), List.of());
    }

    private static boolean buildPluginAvailable() {
        try {
            return APContext.getBuildResource("avaje-plugin-exists.txt").toFile().exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    static void validateModule() {
        ModuleElement module = APContext.getProjectModuleElement();
        if (module != null && !module.isUnnamed()) {
            boolean injectPresent = ProcessingContext.CTX.get().injectPresent;
            try (BufferedReader reader = APContext.getModuleInfoReader();){
                ModuleInfoReader moduleInfo = new ModuleInfoReader(module, reader);
                moduleInfo.validateServices("io.avaje.jsonb.spi.JsonbExtension", ProcessingContext.CTX.get().services);
                boolean noInjectPlugin = injectPresent && !moduleInfo.containsOnModulePath("io.avaje.jsonb.plugin");
                boolean buildPluginAvailable = ProcessingContext.buildPluginAvailable();
                boolean noDirectJsonb = moduleInfo.requires().stream().noneMatch(r -> r.getDependency().getQualifiedName().contentEquals("io.avaje.jsonb"));
                if (noInjectPlugin && (!buildPluginAvailable || noDirectJsonb)) {
                    APContext.logWarn(module, "`requires io.avaje.jsonb.plugin` must be explicitly added or else avaje-inject may fail to detect and wire the default Jsonb instance", new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void addJsonSpi(String spi) {
        ProcessingContext.CTX.get().services.add(spi);
    }

    static void clear() {
        CTX.remove();
        APContext.clear();
    }

    static Set<String> readExistingMetaInfServices() {
        Set<String> services = ProcessingContext.CTX.get().services;
        try (InputStream file = APContext.filer().getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/io.avaje.jsonb.spi.JsonbExtension").toUri().toURL().openStream();
             BufferedReader buffer = new BufferedReader(new InputStreamReader(file));){
            String line;
            while ((line = buffer.readLine()) != null) {
                line.replaceAll("\\s", "").replace(",", "\n").lines().forEach(services::add);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return services;
    }

    private static final class Ctx {
        private final Map<String, JsonPrism> importedJsonMap = new HashMap<String, JsonPrism>();
        private final Map<String, List<SubTypePrism>> importedSubtypeMap = new HashMap<String, List<SubTypePrism>>();
        private final Set<String> services = new TreeSet<String>();
        private final boolean injectPresent;

        Ctx(ProcessingEnvironment env) {
            this.injectPresent = env.getElementUtils().getTypeElement("io.avaje.inject.Component") != null;
        }
    }
}

