/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.APContext;
import io.avaje.jsonb.generator.ComponentMetaData;
import io.avaje.jsonb.generator.FactoryPrism;
import io.avaje.jsonb.generator.MetaDataPrism;
import io.avaje.jsonb.generator.ProcessingContext;
import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class ComponentReader {
    private final ComponentMetaData componentMetaData;

    ComponentReader(ComponentMetaData metaData) {
        this.componentMetaData = metaData;
    }

    void read() {
        ProcessingContext.readExistingMetaInfServices().stream().map(APContext::typeElement).filter(Objects::nonNull).filter(t -> "io.avaje.jsonb.spi.GeneratedComponent".equals(t.getSuperclass().toString())).findFirst().ifPresent(moduleType -> {
            if (moduleType != null) {
                this.componentMetaData.setFullName(moduleType.getQualifiedName().toString());
                this.readMetaData((TypeElement)moduleType);
            }
        });
    }

    private void readMetaData(TypeElement moduleType) {
        for (AnnotationMirror annotationMirror : moduleType.getAnnotationMirrors()) {
            MetaDataPrism metaData = MetaDataPrism.getInstance(annotationMirror);
            FactoryPrism metaDataFactory = FactoryPrism.getInstance(annotationMirror);
            if (metaData != null) {
                metaData.value().stream().map(TypeMirror::toString).forEach(this.componentMetaData::add);
                continue;
            }
            if (metaDataFactory == null) continue;
            metaDataFactory.value().stream().map(TypeMirror::toString).forEach(this.componentMetaData::addFactory);
        }
    }
}

