/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.stream.core;

import io.avaje.json.stream.core.JGenerator;

final class NumberWriter {
    private static final byte MINUS = 45;
    private static final byte[] MIN_INT = "-2147483648".getBytes();
    private static final byte[] MIN_LONG = "-9223372036854775808".getBytes();
    private static final int[] DIGITS = new int[1000];

    private NumberWriter() {
    }

    static void writeInt(int value, JGenerator sw) {
        byte[] buf = sw.ensureCapacity(11);
        int position = sw.position();
        int current = NumberWriter.serializeInt(buf, position, value);
        sw.advance(current - position);
    }

    private static int serializeInt(byte[] buf, int pos, int value) {
        int i;
        if (value < 0) {
            if (value == Integer.MIN_VALUE) {
                System.arraycopy(MIN_INT, 0, buf, pos, MIN_INT.length);
                return pos + MIN_INT.length;
            }
            i = -value;
            buf[pos++] = 45;
        } else {
            i = value;
        }
        int q1 = i / 1000;
        if (q1 == 0) {
            pos += NumberWriter.writeFirstBuf(buf, DIGITS[i], pos);
            return pos;
        }
        int r1 = i - q1 * 1000;
        int q2 = q1 / 1000;
        if (q2 == 0) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[q1];
            int off = NumberWriter.writeFirstBuf(buf, v2, pos);
            NumberWriter.writeBuf(buf, v1, pos + off);
            return pos + 3 + off;
        }
        int r2 = q1 - q2 * 1000;
        int q3 = q2 / 1000;
        int v1 = DIGITS[r1];
        int v2 = DIGITS[r2];
        if (q3 == 0) {
            pos += NumberWriter.writeFirstBuf(buf, DIGITS[q2], pos);
        } else {
            int r3 = q2 - q3 * 1000;
            buf[pos++] = (byte)(q3 + 48);
            NumberWriter.writeBuf(buf, DIGITS[r3], pos);
            pos += 3;
        }
        NumberWriter.writeBuf(buf, v2, pos);
        NumberWriter.writeBuf(buf, v1, pos + 3);
        return pos + 6;
    }

    private static int writeFirstBuf(byte[] buf, int v, int pos) {
        int start = v >> 24;
        if (start == 0) {
            buf[pos++] = (byte)(v >> 16);
            buf[pos++] = (byte)(v >> 8);
        } else if (start == 1) {
            buf[pos++] = (byte)(v >> 8);
        }
        buf[pos] = (byte)v;
        return 3 - start;
    }

    private static void writeBuf(byte[] buf, int v, int pos) {
        buf[pos] = (byte)(v >> 16);
        buf[pos + 1] = (byte)(v >> 8);
        buf[pos + 2] = (byte)v;
    }

    static void writeLong(long value, JGenerator sw) {
        byte[] buf = sw.ensureCapacity(21);
        int position = sw.position();
        int current = NumberWriter.serializeLong(buf, position, value);
        sw.advance(current - position);
    }

    private static int serializeLong(byte[] buf, int pos, long value) {
        long i;
        if (value < 0L) {
            if (value == Long.MIN_VALUE) {
                System.arraycopy(MIN_LONG, 0, buf, pos, MIN_LONG.length);
                return pos + MIN_LONG.length;
            }
            i = -value;
            buf[pos++] = 45;
        } else {
            i = value;
        }
        long q1 = i / 1000L;
        if (q1 == 0L) {
            pos += NumberWriter.writeFirstBuf(buf, DIGITS[(int)i], pos);
            return pos;
        }
        int r1 = (int)(i - q1 * 1000L);
        long q2 = q1 / 1000L;
        if (q2 == 0L) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[(int)q1];
            int off = NumberWriter.writeFirstBuf(buf, v2, pos);
            NumberWriter.writeBuf(buf, v1, pos + off);
            return pos + 3 + off;
        }
        int r2 = (int)(q1 - q2 * 1000L);
        long q3 = q2 / 1000L;
        if (q3 == 0L) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[r2];
            int v3 = DIGITS[(int)q2];
            pos += NumberWriter.writeFirstBuf(buf, v3, pos);
            NumberWriter.writeBuf(buf, v2, pos);
            NumberWriter.writeBuf(buf, v1, pos + 3);
            return pos + 6;
        }
        int r3 = (int)(q2 - q3 * 1000L);
        int q4 = (int)(q3 / 1000L);
        if (q4 == 0) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[r2];
            int v3 = DIGITS[r3];
            int v4 = DIGITS[(int)q3];
            pos += NumberWriter.writeFirstBuf(buf, v4, pos);
            NumberWriter.writeBuf(buf, v3, pos);
            NumberWriter.writeBuf(buf, v2, pos + 3);
            NumberWriter.writeBuf(buf, v1, pos + 6);
            return pos + 9;
        }
        int r4 = (int)(q3 - (long)(q4 * 1000));
        int q5 = q4 / 1000;
        if (q5 == 0) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[r2];
            int v3 = DIGITS[r3];
            int v4 = DIGITS[r4];
            int v5 = DIGITS[q4];
            pos += NumberWriter.writeFirstBuf(buf, v5, pos);
            NumberWriter.writeBuf(buf, v4, pos);
            NumberWriter.writeBuf(buf, v3, pos + 3);
            NumberWriter.writeBuf(buf, v2, pos + 6);
            NumberWriter.writeBuf(buf, v1, pos + 9);
            return pos + 12;
        }
        int r5 = q4 - q5 * 1000;
        int q6 = q5 / 1000;
        int v1 = DIGITS[r1];
        int v2 = DIGITS[r2];
        int v3 = DIGITS[r3];
        int v4 = DIGITS[r4];
        int v5 = DIGITS[r5];
        if (q6 == 0) {
            pos += NumberWriter.writeFirstBuf(buf, DIGITS[q5], pos);
        } else {
            int r6 = q5 - q6 * 1000;
            buf[pos++] = (byte)(q6 + 48);
            NumberWriter.writeBuf(buf, DIGITS[r6], pos);
            pos += 3;
        }
        NumberWriter.writeBuf(buf, v5, pos);
        NumberWriter.writeBuf(buf, v4, pos + 3);
        NumberWriter.writeBuf(buf, v3, pos + 6);
        NumberWriter.writeBuf(buf, v2, pos + 9);
        NumberWriter.writeBuf(buf, v1, pos + 12);
        return pos + 15;
    }

    static {
        for (int i = 0; i < DIGITS.length; ++i) {
            NumberWriter.DIGITS[i] = (i < 10 ? 0x2000000 : (i < 100 ? 0x1000000 : 0)) + (i / 100 + 48 << 16) + (i / 10 % 10 + 48 << 8) + i % 10 + 48;
        }
    }
}

