/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.stream.core;

import io.avaje.json.JsonReader;
import io.avaje.json.JsonWriter;
import io.avaje.json.PropertyNames;
import io.avaje.json.stream.BufferRecycleStrategy;
import io.avaje.json.stream.BufferedJsonWriter;
import io.avaje.json.stream.BytesJsonWriter;
import io.avaje.json.stream.DelegateJsonWriter;
import io.avaje.json.stream.JsonOutput;
import io.avaje.json.stream.JsonStream;
import io.avaje.json.stream.core.BufferRecycler;
import io.avaje.json.stream.core.JsonGenerator;
import io.avaje.json.stream.core.JsonNames;
import io.avaje.json.stream.core.JsonParser;
import io.avaje.json.stream.core.JsonReadAdapter;
import io.avaje.json.stream.core.JsonStreamBuilder;
import io.avaje.json.stream.core.JsonWriteAdapter;
import io.avaje.json.stream.core.ReaderInputStream;
import io.avaje.json.stream.core.WriterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

final class CoreJsonStream
implements JsonStream {
    private final boolean serializeNulls;
    private final boolean serializeEmpty;
    private final boolean failOnUnknown;
    private final boolean failOnNullPrimitives;
    private final BufferRecycler recycle;

    CoreJsonStream(boolean serializeNulls, boolean serializeEmpty, boolean failOnUnknown, boolean failOnNullPrimitives, BufferRecycleStrategy recycle) {
        this.serializeNulls = serializeNulls;
        this.serializeEmpty = serializeEmpty;
        this.failOnUnknown = failOnUnknown;
        this.failOnNullPrimitives = failOnNullPrimitives;
        this.recycle = CoreJsonStream.init2Recycler(recycle);
    }

    private static BufferRecycler init2Recycler(BufferRecycleStrategy recycle) {
        switch (recycle) {
            case NO_RECYCLING: {
                return BufferRecycler.nonRecyclingPool();
            }
            case LOCK_FREE: {
                return BufferRecycler.lockFreePool();
            }
            case THREAD_LOCAL: {
                return BufferRecycler.threadLocalPool();
            }
            case HYBRID_POOL: {
                return BufferRecycler.hybrid();
            }
        }
        throw new IllegalStateException();
    }

    public static JsonStreamBuilder builder() {
        return new JsonStreamBuilder();
    }

    @Override
    public PropertyNames properties(String ... names) {
        return JsonNames.of(names);
    }

    @Override
    public JsonReader reader(String json) {
        return this.reader(json.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public JsonReader reader(byte[] json) {
        JsonParser parser = this.recycle.parser(json);
        return new JsonReadAdapter(parser, this.recycle, this.failOnUnknown, this.failOnNullPrimitives);
    }

    @Override
    public JsonReader reader(Reader reader) {
        return this.reader(new ReaderInputStream(reader, StandardCharsets.UTF_8));
    }

    @Override
    public JsonReader reader(InputStream inputStream) {
        JsonParser parser = this.recycle.parser(inputStream);
        return new JsonReadAdapter(parser, this.recycle, this.failOnUnknown, this.failOnNullPrimitives);
    }

    @Override
    public JsonWriter writer(Writer writer) {
        return this.writer(new WriterOutputStream(writer, StandardCharsets.UTF_8));
    }

    @Override
    public JsonWriter writer(OutputStream outputStream) {
        return this.writer(JsonOutput.ofStream(outputStream));
    }

    @Override
    public JsonWriter writer(JsonOutput output) {
        return this.wrap(this.gen(output));
    }

    @Override
    public BufferedJsonWriter bufferedWriter() {
        JsonGenerator generator = this.recycle.generator();
        return new BufferedWriter(this.wrap(generator), generator);
    }

    @Override
    public BytesJsonWriter bufferedWriterAsBytes() {
        JsonGenerator generator = this.recycle.generator();
        return new BytesWriter(this.wrap(generator), generator);
    }

    private JsonGenerator gen(JsonOutput output) {
        return this.recycle.generator(output);
    }

    private JsonWriteAdapter wrap(JsonGenerator generator) {
        return new JsonWriteAdapter(generator, this.recycle, this.serializeNulls, this.serializeEmpty);
    }

    private static class BufferedWriter
    extends DelegateJsonWriter
    implements BufferedJsonWriter {
        private final JsonGenerator generator;

        BufferedWriter(JsonWriteAdapter delegate, JsonGenerator generator) {
            super(delegate);
            this.generator = generator;
        }

        @Override
        public String result() {
            return this.generator.toString();
        }
    }

    private static class BytesWriter
    extends DelegateJsonWriter
    implements BytesJsonWriter {
        private final JsonGenerator generator;

        public BytesWriter(JsonWriteAdapter delegate, JsonGenerator generator) {
            super(delegate);
            this.generator = generator;
        }

        @Override
        public byte[] result() {
            return this.generator.toByteArray();
        }
    }
}

