/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.mapper;

import io.avaje.json.JsonAdapter;
import io.avaje.json.JsonReader;
import io.avaje.json.JsonWriter;
import io.avaje.json.PropertyNames;
import io.avaje.json.core.CoreTypes;
import io.avaje.json.mapper.DTypeMapper;
import io.avaje.json.mapper.JsonMapper;
import io.avaje.json.stream.JsonStream;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

final class DJsonMapper
implements JsonMapper {
    private final JsonStream jsonStream;
    private final JsonMapper.Type<Object> objectType;
    private final JsonMapper.Type<Map<String, Object>> mapType;
    private final JsonMapper.Type<List<Object>> listType;

    DJsonMapper(JsonStream jsonStream, CoreTypes.CoreAdapters adapters) {
        this.jsonStream = jsonStream;
        this.objectType = new DTypeMapper<Object>(adapters.objectAdapter(), jsonStream);
        this.mapType = new DTypeMapper<Map<String, Object>>(adapters.mapAdapter(), jsonStream);
        this.listType = new DTypeMapper<List<Object>>(adapters.listAdapter(), jsonStream);
    }

    @Override
    public PropertyNames properties(String ... names) {
        return this.jsonStream.properties(names);
    }

    @Override
    public <T> JsonMapper.Type<T> type(JsonAdapter<T> myAdapter) {
        return new DTypeMapper<T>(myAdapter, this.jsonStream);
    }

    @Override
    public <T> JsonMapper.Type<T> type(Function<JsonMapper, JsonAdapter<T>> adapterFunction) {
        return this.type(adapterFunction.apply(this));
    }

    @Override
    public JsonMapper.Type<Object> object() {
        return this.objectType;
    }

    @Override
    public JsonMapper.Type<Map<String, Object>> map() {
        return this.mapType;
    }

    @Override
    public JsonMapper.Type<List<Object>> list() {
        return this.listType;
    }

    @Override
    public String toJson(Object object) {
        return this.objectType.toJson(object);
    }

    @Override
    public void toJson(Object object, JsonWriter jsonWriter) {
        this.objectType.toJson(object, jsonWriter);
    }

    @Override
    public Object fromJson(String json) {
        return this.objectType.fromJson(json);
    }

    @Override
    public Object fromJson(JsonReader jsonReader) {
        return this.objectType.fromJson(jsonReader);
    }

    @Override
    public Map<String, Object> fromJsonObject(JsonReader jsonReader) {
        return this.mapType.fromJson(jsonReader);
    }

    @Override
    public Map<String, Object> fromJsonObject(String json) {
        return this.mapType.fromJson(json);
    }

    @Override
    public List<Object> fromJsonArray(String json) {
        return this.listType.fromJson(json);
    }

    @Override
    public List<Object> fromJsonArray(JsonReader jsonReader) {
        return this.listType.fromJson(jsonReader);
    }
}

