/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.core;

import io.avaje.json.JsonAdapter;
import io.avaje.json.JsonDataException;
import io.avaje.json.JsonReader;
import io.avaje.json.JsonWriter;
import java.util.LinkedHashMap;
import java.util.Map;

final class MapAdapter<V>
implements JsonAdapter<Map<String, V>> {
    private final JsonAdapter<V> valueAdapter;

    static <V> JsonAdapter<Map<String, V>> create(JsonAdapter<V> valueAdapter) {
        return new MapAdapter<V>(valueAdapter).nullSafe();
    }

    MapAdapter(JsonAdapter<V> valueAdapter) {
        this.valueAdapter = valueAdapter;
    }

    @Override
    public void toJson(JsonWriter writer, Map<String, V> map) {
        writer.beginObject();
        for (Map.Entry<String, V> entry : map.entrySet()) {
            if (entry.getKey() == null) {
                throw new JsonDataException("Map key is null at " + writer.path());
            }
            writer.name(entry.getKey());
            this.valueAdapter.toJson(writer, entry.getValue());
        }
        writer.endObject();
    }

    @Override
    public Map<String, V> fromJson(JsonReader reader) {
        LinkedHashMap<String, V> result = new LinkedHashMap<String, V>();
        reader.beginObject();
        while (reader.hasNextField()) {
            V value;
            String name = reader.nextField();
            V replaced = result.put(name, value = this.valueAdapter.fromJson(reader));
            if (replaced == null) continue;
            throw new JsonDataException(String.format("Map key '%s' has multiple values at path %s : %s and %s", name, reader.location(), replaced, value));
        }
        reader.endObject();
        return result;
    }

    public String toString() {
        return "MapAdapter(" + String.valueOf(this.valueAdapter) + ")";
    }
}

