/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.core;

import io.avaje.json.JsonAdapter;
import io.avaje.json.JsonDataException;
import io.avaje.json.JsonReader;
import io.avaje.json.JsonWriter;
import java.lang.reflect.Type;
import java.util.Objects;

final class BaseAdapters {
    BaseAdapters() {
    }

    static JsonAdapter<?> create(Type type) {
        if (type == Boolean.TYPE) {
            return new BooleanAdapter();
        }
        if (type == Double.TYPE) {
            return new DoubleAdapter();
        }
        if (type == Float.TYPE) {
            return new FloatAdapter();
        }
        if (type == Integer.TYPE) {
            return new IntegerAdapter();
        }
        if (type == Long.TYPE) {
            return new LongAdapter();
        }
        if (type == Boolean.class) {
            return new BooleanAdapter().nullSafe();
        }
        if (type == Double.class) {
            return new DoubleAdapter().nullSafe();
        }
        if (type == Float.class) {
            return new FloatAdapter().nullSafe();
        }
        if (type == Integer.class) {
            return new IntegerAdapter().nullSafe();
        }
        if (type == Long.class) {
            return new LongAdapter().nullSafe();
        }
        if (type == String.class) {
            return new StringAdapter().nullSafe();
        }
        return null;
    }

    private static final class BooleanAdapter
    implements JsonAdapter<Boolean> {
        private BooleanAdapter() {
        }

        @Override
        public Boolean fromJson(JsonReader reader) {
            return reader.readBoolean();
        }

        @Override
        public void toJson(JsonWriter writer, Boolean value) {
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(Boolean)";
        }
    }

    private static final class DoubleAdapter
    implements JsonAdapter<Double> {
        private DoubleAdapter() {
        }

        @Override
        public Double fromJson(JsonReader reader) {
            return reader.readDouble();
        }

        @Override
        public void toJson(JsonWriter writer, Double value) {
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(Double)";
        }
    }

    private static final class FloatAdapter
    implements JsonAdapter<Float> {
        private FloatAdapter() {
        }

        @Override
        public Float fromJson(JsonReader reader) {
            float value = (float)reader.readDouble();
            if (Float.isInfinite(value)) {
                throw new JsonDataException("JSON forbids NaN and infinities: " + value + " at path " + reader.location());
            }
            return Float.valueOf(value);
        }

        @Override
        public void toJson(JsonWriter writer, Float value) {
            Objects.requireNonNull(value);
            writer.value(value.floatValue());
        }

        public String toString() {
            return "JsonAdapter(Float)";
        }
    }

    private static final class IntegerAdapter
    implements JsonAdapter<Integer> {
        private IntegerAdapter() {
        }

        @Override
        public Integer fromJson(JsonReader reader) {
            return reader.readInt();
        }

        @Override
        public void toJson(JsonWriter writer, Integer value) {
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(Integer)";
        }
    }

    private static final class LongAdapter
    implements JsonAdapter<Long> {
        private LongAdapter() {
        }

        @Override
        public Long fromJson(JsonReader reader) {
            return reader.readLong();
        }

        @Override
        public void toJson(JsonWriter writer, Long value) {
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(Long)";
        }
    }

    private static final class StringAdapter
    implements JsonAdapter<String> {
        private StringAdapter() {
        }

        @Override
        public String fromJson(JsonReader reader) {
            return reader.readString();
        }

        @Override
        public void toJson(JsonWriter writer, String value) {
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(String)";
        }
    }
}

