/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.core;

import io.avaje.json.JsonAdapter;
import io.avaje.json.JsonReader;
import io.avaje.json.JsonWriter;
import io.avaje.json.core.ArrayAdapter;
import io.avaje.json.core.BaseAdapters;
import io.avaje.json.core.BasicObjectAdapter;
import io.avaje.json.core.CollectionAdapter;
import io.avaje.json.core.MapAdapter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class CoreTypes {
    private static final Map<Type, JsonAdapter<?>> adapterCache = new ConcurrentHashMap();
    private static final NullPlaceholder NULL_PLACEHOLDER = new NullPlaceholder();

    public static <T> JsonAdapter<T> create(Type type) {
        JsonAdapter adapter = adapterCache.computeIfAbsent(type, CoreTypes::createAdapter);
        return adapter == NULL_PLACEHOLDER ? null : adapter;
    }

    public static <T> JsonAdapter<T> createArray(Class<?> elementType) {
        JsonAdapter<Object> adapter = CoreTypes.createAdapter(elementType);
        return CoreTypes.createArray(elementType, adapter);
    }

    public static <T> JsonAdapter<T> createArray(Class<?> elementType, JsonAdapter<Object> adapter) {
        return ArrayAdapter.create(Objects.requireNonNull(elementType), Objects.requireNonNull(adapter));
    }

    public static JsonAdapter<byte[]> byteArray() {
        return ArrayAdapter.byteArray();
    }

    public static <V> JsonAdapter<Map<String, V>> createMap(JsonAdapter<V> valueAdapter) {
        return MapAdapter.create(valueAdapter);
    }

    public static <V> JsonAdapter<List<V>> createList(JsonAdapter<V> elementAdapter) {
        return CollectionAdapter.createList(elementAdapter);
    }

    public static <V> JsonAdapter<Set<V>> createSet(JsonAdapter<V> elementAdapter) {
        return CollectionAdapter.createSet(elementAdapter);
    }

    public static CoreAdapters createCoreAdapters() {
        return new BasicObjectAdapter();
    }

    private static JsonAdapter<?> createAdapter(Type type) {
        JsonAdapter<?> adapter = BaseAdapters.create(type);
        if (adapter != null) {
            return adapter;
        }
        return NULL_PLACEHOLDER;
    }

    static final class NullPlaceholder
    implements JsonAdapter<Void> {
        NullPlaceholder() {
        }

        @Override
        public void toJson(JsonWriter writer, Void value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Void fromJson(JsonReader reader) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface CoreAdapters {
        public JsonAdapter<Object> objectAdapter();

        public JsonAdapter<List<Object>> listAdapter();

        public JsonAdapter<Map<String, Object>> mapAdapter();
    }
}

