/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.json.simple;

import io.avaje.json.JsonAdapter;
import io.avaje.json.PropertyNames;
import io.avaje.json.core.CoreTypes;
import io.avaje.json.simple.DTypeMapper;
import io.avaje.json.simple.SimpleMapper;
import io.avaje.json.stream.JsonStream;
import java.util.List;
import java.util.Map;

final class DSimpleMapper
implements SimpleMapper {
    private final JsonStream jsonStream;
    private final SimpleMapper.Type<Object> objectType;
    private final SimpleMapper.Type<Map<String, Object>> mapType;
    private final SimpleMapper.Type<List<Object>> listType;

    DSimpleMapper(JsonStream jsonStream, CoreTypes.CoreAdapters adapters) {
        this.jsonStream = jsonStream;
        this.objectType = new DTypeMapper<Object>(adapters.objectAdapter(), jsonStream);
        this.mapType = new DTypeMapper<Map<String, Object>>(adapters.mapAdapter(), jsonStream);
        this.listType = new DTypeMapper<List<Object>>(adapters.listAdapter(), jsonStream);
    }

    @Override
    public PropertyNames properties(String ... names) {
        return this.jsonStream.properties(names);
    }

    @Override
    public <T> SimpleMapper.Type<T> type(JsonAdapter<T> myAdapter) {
        return new DTypeMapper<T>(myAdapter, this.jsonStream);
    }

    @Override
    public SimpleMapper.Type<Object> object() {
        return this.objectType;
    }

    @Override
    public SimpleMapper.Type<Map<String, Object>> map() {
        return this.mapType;
    }

    @Override
    public SimpleMapper.Type<List<Object>> list() {
        return this.listType;
    }

    @Override
    public String toJson(Object object) {
        return this.objectType.toJson(object);
    }

    @Override
    public Object fromJson(String json) {
        return this.objectType.fromJson(json);
    }

    @Override
    public Map<String, Object> fromJsonObject(String json) {
        return this.mapType.fromJson(json);
    }

    @Override
    public List<Object> fromJsonArray(String json) {
        return this.listType.fromJson(json);
    }
}

