/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.test;

import io.avaje.inject.BeanScope;
import io.avaje.inject.BeanScopeBuilder;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Spy;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.util.reflection.GenericMaster;
import org.mockito.plugins.MemberAccessor;

class MetaReader {
    private final List<Field> captors = new ArrayList<Field>();
    private final List<FieldTarget> mocks = new ArrayList<FieldTarget>();
    private final List<FieldTarget> spies = new ArrayList<FieldTarget>();
    private final List<FieldTarget> injection = new ArrayList<FieldTarget>();
    private final Object testInstance;

    MetaReader(Object testInstance) {
        this.testInstance = testInstance;
        for (Field field : testInstance.getClass().getDeclaredFields()) {
            this.readField(field);
        }
    }

    public String toString() {
        String s = this.toStringAppend("mocks:", this.mocks);
        s = s + this.toStringAppend("spies:", this.spies);
        s = s + this.toStringAppend("inject:", this.injection);
        s = s + this.toStringAppend("captors:", this.captors);
        return s;
    }

    private String toStringAppend(String key, List<?> entries) {
        return entries.isEmpty() ? "" : key + entries + "; ";
    }

    List<FieldTarget> mocks() {
        return this.mocks;
    }

    private void readField(Field field) {
        Mock mockAnnotation = field.getAnnotation(Mock.class);
        if (mockAnnotation != null) {
            this.mocks.add(this.newTarget(field));
            return;
        }
        Spy spyAnnotation = field.getAnnotation(Spy.class);
        if (spyAnnotation != null) {
            this.spies.add(this.newTarget(field));
            return;
        }
        Captor captorAnnotation = field.getAnnotation(Captor.class);
        if (captorAnnotation != null) {
            this.captors.add(field);
            return;
        }
        Inject injectAnnotation = field.getAnnotation(Inject.class);
        if (injectAnnotation != null) {
            this.injection.add(this.newTarget(field));
        }
    }

    private FieldTarget newTarget(Field field) {
        return new FieldTarget(field, this.name(field));
    }

    private String name(Field field) {
        Named named = field.getAnnotation(Named.class);
        if (named != null) {
            return named.value().toLowerCase();
        }
        for (Annotation annotation : field.getAnnotations()) {
            for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                if (!metaAnnotation.annotationType().equals(Qualifier.class)) continue;
                return annotation.annotationType().getSimpleName().toLowerCase();
            }
        }
        return null;
    }

    void setFromScope(BeanScope beanScope) {
        try {
            for (Field field : this.captors) {
                this.set(field, this.captorFor(field));
            }
            for (FieldTarget mock : this.mocks) {
                mock.setFromScope(beanScope);
            }
            for (FieldTarget target : this.spies) {
                target.setFromScope(beanScope);
            }
            for (FieldTarget target : this.injection) {
                target.setFromScope(beanScope);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Object captorFor(Field field) {
        Class<?> type = field.getType();
        if (!ArgumentCaptor.class.isAssignableFrom(type)) {
            throw new IllegalStateException("@Captor field must be of the type ArgumentCaptor.\n Field: '" + field.getName() + "' has wrong type");
        }
        Class cls = new GenericMaster().getGenericType(field);
        return ArgumentCaptor.forClass((Class)cls);
    }

    void build(BeanScopeBuilder builder) {
        BeanScopeBuilder.ForTesting forTesting = builder.forTesting();
        for (FieldTarget target : this.mocks) {
            forTesting.withMock(target.type(), target.name());
        }
        for (FieldTarget target : this.spies) {
            forTesting.withSpy(target.type(), target.name());
        }
    }

    void set(Field field, Object val) throws IllegalAccessException {
        MemberAccessor memberAccessor = Plugins.getMemberAccessor();
        memberAccessor.set(field, this.testInstance, val);
    }

    class FieldTarget {
        private final Field field;
        private final String name;

        FieldTarget(Field field, String name) {
            this.field = field;
            this.name = name;
        }

        public String toString() {
            return this.field.getName();
        }

        Class<?> type() {
            return this.field.getType();
        }

        String name() {
            return this.name;
        }

        void setFromScope(BeanScope beanScope) throws IllegalAccessException {
            MetaReader.this.set(this.field, beanScope.get(this.type(), this.name));
        }
    }
}

