/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.test;

import io.avaje.inject.BeanScope;
import io.avaje.inject.BeanScopeBuilder;
import io.avaje.inject.spi.Module;
import io.avaje.inject.test.MetaReader;
import io.avaje.inject.test.TestModule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
ExtensionContext.Store.CloseableResource {
    private static final Logger log = LoggerFactory.getLogger(InjectExtension.class);
    private static final ExtensionContext.Namespace INJECT_NS = ExtensionContext.Namespace.create((Object[])new Object[]{"io.avaje.inject.InjectTest"});
    private static final String BEAN_SCOPE = "BEAN_SCOPE";
    private static final ReentrantLock lock = new ReentrantLock();
    private static boolean started;
    private static BeanScope globalTestScope;

    public void beforeAll(ExtensionContext context) {
        lock.lock();
        try {
            if (!started) {
                this.initialiseGlobalTestScope(context);
                started = true;
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void close() throws Throwable {
        lock.lock();
        try {
            if (globalTestScope != null) {
                log.debug("Closing global test BeanScope");
                globalTestScope.close();
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void initialiseGlobalTestScope(ExtensionContext context) {
        Iterator<TestModule> iterator = ServiceLoader.load(TestModule.class).iterator();
        if (iterator.hasNext()) {
            log.debug("Building global test BeanScope (as parent scope for tests)");
            globalTestScope = BeanScope.newBuilder().withModules(new Module[]{(Module)iterator.next()}).build();
            log.trace("register global test BeanScope with beans {}", (Object)globalTestScope);
            context.getRoot().getStore(ExtensionContext.Namespace.GLOBAL).put((Object)InjectExtension.class.getCanonicalName(), (Object)this);
        }
    }

    public void beforeEach(ExtensionContext context) {
        List<MetaReader> readers = this.createMetaReaders(context);
        BeanScopeBuilder builder = BeanScope.newBuilder();
        if (globalTestScope != null) {
            builder.withParent(globalTestScope, false);
        }
        for (MetaReader reader : readers) {
            reader.build(builder);
        }
        BeanScope beanScope = builder.build();
        for (MetaReader reader : readers) {
            reader.setFromScope(beanScope);
        }
        log.trace("test setup with {}", readers);
        context.getStore(INJECT_NS).put((Object)BEAN_SCOPE, (Object)beanScope);
    }

    private List<MetaReader> createMetaReaders(ExtensionContext context) {
        List testInstances = context.getRequiredTestInstances().getAllInstances();
        ArrayList<MetaReader> readers = new ArrayList<MetaReader>(testInstances.size());
        for (Object testInstance : testInstances) {
            readers.add(new MetaReader(testInstance));
        }
        return readers;
    }

    public void afterEach(ExtensionContext context) {
        BeanScope beanScope = (BeanScope)context.getStore(INJECT_NS).remove((Object)BEAN_SCOPE);
        if (beanScope != null) {
            beanScope.close();
        }
    }
}

