/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.time;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import io.atomix.utils.misc.TimestampPrinter;
import io.atomix.utils.time.Timestamp;
import java.util.Objects;

public class WallClockTimestamp
implements Timestamp {
    private final long unixTimestamp;

    public static WallClockTimestamp from(long unixTimestamp) {
        return new WallClockTimestamp(unixTimestamp);
    }

    public WallClockTimestamp() {
        this.unixTimestamp = System.currentTimeMillis();
    }

    public WallClockTimestamp(long timestamp) {
        this.unixTimestamp = timestamp;
    }

    @Override
    public int compareTo(Timestamp o) {
        Preconditions.checkArgument((boolean)(o instanceof WallClockTimestamp), (String)"Must be WallClockTimestamp", (Object)o);
        WallClockTimestamp that = (WallClockTimestamp)o;
        return ComparisonChain.start().compare(this.unixTimestamp, that.unixTimestamp).result();
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.unixTimestamp);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WallClockTimestamp)) {
            return false;
        }
        WallClockTimestamp that = (WallClockTimestamp)obj;
        return Objects.equals(this.unixTimestamp, that.unixTimestamp);
    }

    public String toString() {
        return new TimestampPrinter(this.unixTimestamp).toString();
    }

    public long unixTimestamp() {
        return this.unixTimestamp;
    }
}

