/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.RaftException;

public class RaftError {
    private final Type type;
    private final String message;

    public RaftError(Type type, String message) {
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type cannot be null"));
        this.message = message;
    }

    public Type type() {
        return this.type;
    }

    public String message() {
        return this.message;
    }

    public RaftException createException() {
        return this.type.createException(this.message);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("message", (Object)this.message).toString();
    }

    public static enum Type {
        NO_LEADER{

            @Override
            RaftException createException() {
                return this.createException("Failed to locate leader");
            }

            @Override
            RaftException createException(String message) {
                return message != null ? new RaftException.NoLeader(message, new Object[0]) : this.createException();
            }
        }
        ,
        QUERY_FAILURE{

            @Override
            RaftException createException() {
                return this.createException("Failed to obtain read quorum");
            }

            @Override
            RaftException createException(String message) {
                return message != null ? new RaftException.QueryFailure(message, new Object[0]) : this.createException();
            }
        }
        ,
        COMMAND_FAILURE{

            @Override
            RaftException createException() {
                return this.createException("Failed to obtain write quorum");
            }

            @Override
            RaftException createException(String message) {
                return message != null ? new RaftException.CommandFailure(message, new Object[0]) : this.createException();
            }
        }
        ,
        APPLICATION_ERROR{

            @Override
            RaftException createException() {
                return this.createException("An application error occurred");
            }

            @Override
            RaftException createException(String message) {
                return message != null ? new RaftException.ApplicationException(message, new Object[0]) : this.createException();
            }
        }
        ,
        ILLEGAL_MEMBER_STATE{

            @Override
            RaftException createException() {
                return this.createException("Illegal member state");
            }

            @Override
            RaftException createException(String message) {
                return message != null ? new RaftException.IllegalMemberState(message, new Object[0]) : this.createException();
            }
        }
        ,
        UNKNOWN_CLIENT{

            @Override
            RaftException createException() {
                return this.createException("Unknown client");
            }

            @Override
            RaftException createException(String message) {
                return message != null ? new RaftException.UnknownClient(message, new Object[0]) : this.createException();
            }
        }
        ,
        UNKNOWN_SESSION{

            @Override
            RaftException createException() {
                return this.createException("Unknown member session");
            }

            @Override
            RaftException createException(String message) {
                return message != null ? new RaftException.UnknownSession(message, new Object[0]) : this.createException();
            }
        }
        ,
        UNKNOWN_SERVICE{

            @Override
            RaftException createException() {
                return this.createException("Unknown state machine");
            }

            @Override
            RaftException createException(String message) {
                return message != null ? new RaftException.UnknownService(message, new Object[0]) : this.createException();
            }
        }
        ,
        CLOSED_SESSION{

            @Override
            RaftException createException() {
                return this.createException("Closed session");
            }

            @Override
            RaftException createException(String message) {
                return message != null ? new RaftException.ClosedSession(message, new Object[0]) : this.createException();
            }
        }
        ,
        PROTOCOL_ERROR{

            @Override
            RaftException createException() {
                return this.createException("Failed to reach consensus");
            }

            @Override
            RaftException createException(String message) {
                return message != null ? new RaftException.ProtocolException(message, new Object[0]) : this.createException();
            }
        }
        ,
        CONFIGURATION_ERROR{

            @Override
            RaftException createException() {
                return this.createException("Configuration failed");
            }

            @Override
            RaftException createException(String message) {
                return message != null ? new RaftException.ConfigurationException(message, new Object[0]) : this.createException();
            }
        }
        ,
        UNAVAILABLE{

            @Override
            RaftException createException() {
                return this.createException("Service is unavailable");
            }

            @Override
            RaftException createException(String message) {
                return message != null ? new RaftException.Unavailable(message, new Object[0]) : this.createException();
            }
        };


        abstract RaftException createException();

        abstract RaftException createException(String var1);
    }
}

