/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.ConfigureRequest;
import io.atomix.protocols.raft.protocol.ConfigureResponse;
import io.atomix.protocols.raft.protocol.InstallRequest;
import io.atomix.protocols.raft.protocol.InstallResponse;
import io.atomix.protocols.raft.protocol.JoinRequest;
import io.atomix.protocols.raft.protocol.JoinResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.LeaveRequest;
import io.atomix.protocols.raft.protocol.LeaveResponse;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.PollRequest;
import io.atomix.protocols.raft.protocol.PollResponse;
import io.atomix.protocols.raft.protocol.PublishRequest;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.ReconfigureRequest;
import io.atomix.protocols.raft.protocol.ReconfigureResponse;
import io.atomix.protocols.raft.protocol.ResetRequest;
import io.atomix.protocols.raft.protocol.TransferRequest;
import io.atomix.protocols.raft.protocol.TransferResponse;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.protocols.raft.session.SessionId;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public interface RaftServerProtocol {
    public CompletableFuture<OpenSessionResponse> openSession(MemberId var1, OpenSessionRequest var2);

    public CompletableFuture<CloseSessionResponse> closeSession(MemberId var1, CloseSessionRequest var2);

    public CompletableFuture<KeepAliveResponse> keepAlive(MemberId var1, KeepAliveRequest var2);

    public CompletableFuture<QueryResponse> query(MemberId var1, QueryRequest var2);

    public CompletableFuture<CommandResponse> command(MemberId var1, CommandRequest var2);

    public CompletableFuture<MetadataResponse> metadata(MemberId var1, MetadataRequest var2);

    public CompletableFuture<JoinResponse> join(MemberId var1, JoinRequest var2);

    public CompletableFuture<LeaveResponse> leave(MemberId var1, LeaveRequest var2);

    public CompletableFuture<ConfigureResponse> configure(MemberId var1, ConfigureRequest var2);

    public CompletableFuture<ReconfigureResponse> reconfigure(MemberId var1, ReconfigureRequest var2);

    public CompletableFuture<InstallResponse> install(MemberId var1, InstallRequest var2);

    public CompletableFuture<TransferResponse> transfer(MemberId var1, TransferRequest var2);

    public CompletableFuture<PollResponse> poll(MemberId var1, PollRequest var2);

    public CompletableFuture<VoteResponse> vote(MemberId var1, VoteRequest var2);

    public CompletableFuture<AppendResponse> append(MemberId var1, AppendRequest var2);

    public void publish(MemberId var1, PublishRequest var2);

    public void registerOpenSessionHandler(Function<OpenSessionRequest, CompletableFuture<OpenSessionResponse>> var1);

    public void unregisterOpenSessionHandler();

    public void registerCloseSessionHandler(Function<CloseSessionRequest, CompletableFuture<CloseSessionResponse>> var1);

    public void unregisterCloseSessionHandler();

    public void registerKeepAliveHandler(Function<KeepAliveRequest, CompletableFuture<KeepAliveResponse>> var1);

    public void unregisterKeepAliveHandler();

    public void registerQueryHandler(Function<QueryRequest, CompletableFuture<QueryResponse>> var1);

    public void unregisterQueryHandler();

    public void registerCommandHandler(Function<CommandRequest, CompletableFuture<CommandResponse>> var1);

    public void unregisterCommandHandler();

    public void registerMetadataHandler(Function<MetadataRequest, CompletableFuture<MetadataResponse>> var1);

    public void unregisterMetadataHandler();

    public void registerJoinHandler(Function<JoinRequest, CompletableFuture<JoinResponse>> var1);

    public void unregisterJoinHandler();

    public void registerLeaveHandler(Function<LeaveRequest, CompletableFuture<LeaveResponse>> var1);

    public void unregisterLeaveHandler();

    public void registerTransferHandler(Function<TransferRequest, CompletableFuture<TransferResponse>> var1);

    public void unregisterTransferHandler();

    public void registerConfigureHandler(Function<ConfigureRequest, CompletableFuture<ConfigureResponse>> var1);

    public void unregisterConfigureHandler();

    public void registerReconfigureHandler(Function<ReconfigureRequest, CompletableFuture<ReconfigureResponse>> var1);

    public void unregisterReconfigureHandler();

    public void registerInstallHandler(Function<InstallRequest, CompletableFuture<InstallResponse>> var1);

    public void unregisterInstallHandler();

    public void registerPollHandler(Function<PollRequest, CompletableFuture<PollResponse>> var1);

    public void unregisterPollHandler();

    public void registerVoteHandler(Function<VoteRequest, CompletableFuture<VoteResponse>> var1);

    public void unregisterVoteHandler();

    public void registerAppendHandler(Function<AppendRequest, CompletableFuture<AppendResponse>> var1);

    public void unregisterAppendHandler();

    public void registerResetListener(SessionId var1, Consumer<ResetRequest> var2, Executor var3);

    public void unregisterResetListener(SessionId var1);
}

