/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.coordination;

import io.atomix.coordination.state.LockCommands;
import io.atomix.coordination.state.LockState;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceTypeInfo;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

@ResourceTypeInfo(id=-22, stateMachine=LockState.class, typeResolver=LockCommands.TypeResolver.class)
public class DistributedLock
extends Resource<DistributedLock> {
    private final Map<Integer, CompletableFuture<Long>> futures = new ConcurrentHashMap<Integer, CompletableFuture<Long>>();
    private final AtomicInteger id = new AtomicInteger();
    private int lock;

    public static Resource.Options options() {
        return new Resource.Options();
    }

    public static Resource.Config config() {
        return new Resource.Config();
    }

    public DistributedLock(CopycatClient client, Resource.Options options) {
        super(client, options);
    }

    public CompletableFuture<DistributedLock> open() {
        return super.open().thenApply(result -> {
            this.client.onEvent("lock", this::handleEvent);
            this.client.onEvent("fail", this::handleFail);
            return result;
        });
    }

    private void handleEvent(LockCommands.LockEvent event) {
        CompletableFuture<Long> future = this.futures.get(event.id());
        if (future != null) {
            this.lock = event.id();
            future.complete(event.version());
        }
    }

    private void handleFail(LockCommands.LockEvent event) {
        CompletableFuture<Long> future = this.futures.get(event.id());
        if (future != null) {
            future.complete(null);
        }
    }

    public CompletableFuture<Long> lock() {
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        int id = this.id.incrementAndGet();
        this.futures.put(id, future);
        this.submit(new LockCommands.Lock(id, -1L)).whenComplete((result, error) -> {
            if (error != null) {
                this.futures.remove(id);
                future.completeExceptionally((Throwable)error);
            }
        });
        return future;
    }

    public CompletableFuture<Long> tryLock() {
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        int id = this.id.incrementAndGet();
        this.futures.put(id, future);
        this.submit(new LockCommands.Lock(id, 0L)).whenComplete((result, error) -> {
            if (error != null) {
                this.futures.remove(id);
                future.completeExceptionally((Throwable)error);
            }
        });
        return future;
    }

    public CompletableFuture<Long> tryLock(Duration timeout) {
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        int id = this.id.incrementAndGet();
        this.futures.put(id, future);
        this.submit(new LockCommands.Lock(id, timeout.toMillis())).whenComplete((result, error) -> {
            if (error != null) {
                this.futures.remove(id);
                future.completeExceptionally((Throwable)error);
            }
        });
        return future;
    }

    public CompletableFuture<Void> unlock() {
        int lock = this.lock;
        this.lock = 0;
        if (lock != 0) {
            return this.submit(new LockCommands.Unlock(lock));
        }
        return CompletableFuture.completedFuture(null);
    }
}

