/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.atomix.cluster.messaging.BroadcastService;
import io.atomix.cluster.messaging.ManagedBroadcastService;
import io.atomix.utils.AtomixRuntimeException;
import io.atomix.utils.concurrent.Threads;
import io.atomix.utils.net.Address;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyBroadcastService
implements ManagedBroadcastService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final boolean enabled;
    private final InetSocketAddress localAddress;
    private final InetSocketAddress groupAddress;
    private final NetworkInterface iface;
    private EventLoopGroup group;
    private Channel serverChannel;
    private DatagramChannel clientChannel;
    private final Set<Consumer<byte[]>> listeners = Sets.newCopyOnWriteArraySet();
    private final AtomicBoolean started = new AtomicBoolean();

    public static Builder builder() {
        return new Builder();
    }

    public NettyBroadcastService(Address localAddress, Address groupAddress, boolean enabled) {
        this.enabled = enabled;
        this.localAddress = new InetSocketAddress(localAddress.host(), groupAddress.port());
        this.groupAddress = new InetSocketAddress(groupAddress.host(), groupAddress.port());
        try {
            this.iface = NetworkInterface.getByInetAddress(localAddress.address());
        }
        catch (SocketException e) {
            throw new AtomixRuntimeException((Throwable)e);
        }
    }

    @Override
    public void broadcast(byte[] message) {
        if (this.enabled) {
            ByteBuf buf = this.serverChannel.alloc().buffer();
            buf.writeInt(message.length).writeBytes(message);
            this.serverChannel.writeAndFlush((Object)new DatagramPacket(buf, this.groupAddress));
        }
    }

    @Override
    public void addListener(Consumer<byte[]> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Consumer<byte[]> listener) {
        this.listeners.remove(listener);
    }

    private CompletableFuture<Void> bootstrapServer() {
        Bootstrap serverBootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channelFactory(() -> new NioDatagramChannel(InternetProtocolFamily.IPv4))).handler((ChannelHandler)new SimpleChannelInboundHandler<Object>(){

            public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            }
        })).option(ChannelOption.IP_MULTICAST_IF, (Object)this.iface)).option(ChannelOption.SO_REUSEADDR, (Object)true);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        serverBootstrap.bind((SocketAddress)this.localAddress).addListener((GenericFutureListener)((ChannelFutureListener)f -> {
            if (f.isSuccess()) {
                this.serverChannel = f.channel();
                future.complete(null);
            } else {
                future.completeExceptionally(f.cause());
            }
        }));
        return future;
    }

    private CompletableFuture<Void> bootstrapClient() {
        Bootstrap clientBootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channelFactory(() -> new NioDatagramChannel(InternetProtocolFamily.IPv4))).handler((ChannelHandler)new SimpleChannelInboundHandler<DatagramPacket>(){

            protected void channelRead0(ChannelHandlerContext context, DatagramPacket packet) throws Exception {
                byte[] message = new byte[((ByteBuf)packet.content()).readInt()];
                ((ByteBuf)packet.content()).readBytes(message);
                for (Consumer listener : NettyBroadcastService.this.listeners) {
                    listener.accept(message);
                }
            }
        })).option(ChannelOption.IP_MULTICAST_IF, (Object)this.iface)).option(ChannelOption.SO_REUSEADDR, (Object)true)).localAddress(this.localAddress.getPort());
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        clientBootstrap.bind().addListener((GenericFutureListener)((ChannelFutureListener)f -> {
            if (f.isSuccess()) {
                this.clientChannel = (DatagramChannel)f.channel();
                this.log.info("{} joining multicast group {} on port {}", new Object[]{this.localAddress.getHostName(), this.groupAddress.getHostName(), this.groupAddress.getPort()});
                this.clientChannel.joinGroup(this.groupAddress, this.iface).addListener(f2 -> {
                    if (f2.isSuccess()) {
                        this.log.info("{} successfully joined multicast group {} on port {}", new Object[]{this.localAddress.getHostName(), this.groupAddress.getHostName(), this.groupAddress.getPort()});
                        future.complete(null);
                    } else {
                        this.log.info("{} failed to join group {} on port {}", new Object[]{this.localAddress.getHostName(), this.groupAddress.getHostName(), this.groupAddress.getPort()});
                        future.completeExceptionally(f2.cause());
                    }
                });
            } else {
                future.completeExceptionally(f.cause());
            }
        }));
        return future;
    }

    public CompletableFuture<BroadcastService> start() {
        if (!this.enabled) {
            return CompletableFuture.completedFuture(this);
        }
        this.group = new NioEventLoopGroup(0, Threads.namedThreads((String)"netty-broadcast-event-nio-client-%d", (Logger)this.log));
        return ((CompletableFuture)((CompletableFuture)this.bootstrapServer().thenCompose(v -> this.bootstrapClient())).thenRun(() -> this.started.set(true))).thenApply(v -> this);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        if (!this.enabled) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.clientChannel != null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            this.clientChannel.leaveGroup(this.groupAddress, this.iface).addListener(f -> {
                this.started.set(false);
                this.group.shutdownGracefully();
                future.complete(null);
            });
            return future;
        }
        this.started.set(false);
        return CompletableFuture.completedFuture(null);
    }

    public static class Builder
    implements BroadcastService.Builder {
        private Address localAddress;
        private Address groupAddress;
        private boolean enabled = true;

        public Builder withLocalAddress(Address address) {
            this.localAddress = (Address)Preconditions.checkNotNull((Object)address);
            return this;
        }

        public Builder withGroupAddress(Address address) {
            this.groupAddress = (Address)Preconditions.checkNotNull((Object)address);
            return this;
        }

        public Builder withEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public ManagedBroadcastService build() {
            return new NettyBroadcastService(this.localAddress, this.groupAddress, this.enabled);
        }
    }
}

