/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import io.atomix.storage.buffer.Bytes;
import io.atomix.storage.buffer.NativeBytes;
import io.atomix.utils.memory.MappedMemory;
import io.atomix.utils.memory.MappedMemoryAllocator;
import io.atomix.utils.memory.NativeMemory;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;

public class UnsafeMappedBytes
extends NativeBytes {
    private final File file;

    public static UnsafeMappedBytes allocate(File file, int size) {
        return UnsafeMappedBytes.allocate(file, MappedMemoryAllocator.DEFAULT_MAP_MODE, size);
    }

    public static UnsafeMappedBytes allocate(File file, FileChannel.MapMode mode, int size) {
        if (file == null) {
            throw new NullPointerException("file cannot be null");
        }
        if (mode == null) {
            mode = MappedMemoryAllocator.DEFAULT_MAP_MODE;
        }
        if ((long)size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size for MappedBytes cannot be greater than 2147483647");
        }
        return new UnsafeMappedBytes(file, MappedMemory.allocate((File)file, (FileChannel.MapMode)mode, (int)size));
    }

    protected UnsafeMappedBytes(File file, MappedMemory memory) {
        super((NativeMemory)memory);
        this.file = file;
    }

    public UnsafeMappedBytes copy() {
        throw new UnsupportedOperationException("copy");
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public Bytes flush() {
        ((MappedMemory)this.memory).flush();
        return this;
    }

    @Override
    public void close() {
        ((MappedMemory)this.memory).close();
    }

    public void delete() {
        try {
            this.close();
            Files.delete(this.file.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

