/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import com.google.common.base.Preconditions;
import io.atomix.storage.buffer.ByteBufferBuffer;
import io.atomix.storage.buffer.HeapBytes;
import io.atomix.utils.memory.Memory;

public class HeapBuffer
extends ByteBufferBuffer {
    private final HeapBytes bytes;

    public static HeapBuffer allocate() {
        return HeapBuffer.allocate(4096, Integer.MAX_VALUE);
    }

    public static HeapBuffer allocate(int initialCapacity) {
        return HeapBuffer.allocate(initialCapacity, Integer.MAX_VALUE);
    }

    public static HeapBuffer allocate(int initialCapacity, int maxCapacity) {
        Preconditions.checkArgument((initialCapacity <= maxCapacity ? 1 : 0) != 0, (Object)"initial capacity cannot be greater than maximum capacity");
        return new HeapBuffer(HeapBytes.allocate((int)Math.min(Memory.Util.toPow2((int)initialCapacity), Integer.MAX_VALUE)), 0, initialCapacity, maxCapacity);
    }

    public static HeapBuffer wrap(byte[] bytes) {
        return new HeapBuffer(HeapBytes.wrap(bytes), 0, bytes.length, bytes.length);
    }

    protected HeapBuffer(HeapBytes bytes, int offset, int initialCapacity, int maxCapacity) {
        super(bytes, offset, initialCapacity, maxCapacity, null);
        this.bytes = bytes;
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public HeapBuffer duplicate() {
        return new HeapBuffer(this.bytes, this.offset(), this.capacity(), this.maxCapacity());
    }
}

