/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import io.atomix.storage.buffer.AbstractBytes;
import io.atomix.storage.buffer.Bytes;
import io.atomix.storage.buffer.MappedBytes;
import io.atomix.storage.buffer.WrappedBytes;
import io.atomix.utils.memory.Memory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;

public class FileBytes
extends AbstractBytes {
    static final String DEFAULT_MODE = "rw";
    private final File file;
    private final String mode;
    private final RandomAccessFile randomAccessFile;
    private int size;

    public static FileBytes allocate(File file) {
        return FileBytes.allocate(file, DEFAULT_MODE, Integer.MAX_VALUE);
    }

    public static FileBytes allocate(File file, int size) {
        return FileBytes.allocate(file, DEFAULT_MODE, size);
    }

    public static FileBytes allocate(File file, String mode, int size) {
        return new FileBytes(file, mode, (int)Math.min(Memory.Util.toPow2((int)size), Integer.MAX_VALUE));
    }

    FileBytes(File file, String mode, int size) {
        if (file == null) {
            throw new NullPointerException("file cannot be null");
        }
        if (mode == null) {
            mode = DEFAULT_MODE;
        }
        if (size < 0) {
            throw new IllegalArgumentException("size must be positive");
        }
        this.file = file;
        this.mode = mode;
        this.size = size;
        try {
            this.randomAccessFile = new RandomAccessFile(file, mode);
            if ((long)size > this.randomAccessFile.length()) {
                this.randomAccessFile.setLength(size);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File file() {
        return this.file;
    }

    public String mode() {
        return this.mode;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Bytes resize(int newSize) {
        if (newSize < this.size) {
            throw new IllegalArgumentException("cannot decrease file bytes size; use zero() to decrease file size");
        }
        this.size = newSize;
        try {
            long length = this.randomAccessFile.length();
            if ((long)this.size > length) {
                this.randomAccessFile.setLength(newSize);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    public MappedBytes map(int offset, int size) {
        return this.map(offset, size, FileBytes.parseMode(this.mode));
    }

    public MappedBytes map(int offset, int size, FileChannel.MapMode mode) {
        MappedByteBuffer mappedByteBuffer = FileBytes.mapFile(this.randomAccessFile, offset, size, mode);
        return new MappedBytes(this.file, this.randomAccessFile, mappedByteBuffer, mode);
    }

    private static MappedByteBuffer mapFile(RandomAccessFile randomAccessFile, int offset, int size, FileChannel.MapMode mode) {
        try {
            return randomAccessFile.getChannel().map(mode, offset, size);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static FileChannel.MapMode parseMode(String mode) {
        switch (mode) {
            case "r": {
                return FileChannel.MapMode.READ_ONLY;
            }
        }
        return FileChannel.MapMode.READ_WRITE;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    private void seekToOffset(int offset) throws IOException {
        if (this.randomAccessFile.getFilePointer() != (long)offset) {
            this.randomAccessFile.seek(offset);
        }
    }

    @Override
    public Bytes zero() {
        try {
            this.randomAccessFile.setLength(0L);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes zero(int offset) {
        try {
            this.randomAccessFile.setLength(offset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes zero(int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.writeByte(i, 0);
        }
        return this;
    }

    @Override
    public Bytes read(int position, Bytes bytes, int offset, int length) {
        this.checkRead(position, length);
        if (bytes instanceof WrappedBytes) {
            bytes = ((WrappedBytes)bytes).root();
        }
        if (bytes.hasArray()) {
            try {
                this.seekToOffset(position);
                this.randomAccessFile.read(bytes.array(), offset, length);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.seekToOffset(position);
            byte[] readBytes = new byte[length];
            this.randomAccessFile.read(readBytes);
            bytes.write(offset, readBytes, 0, length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes read(int position, byte[] bytes, int offset, int length) {
        this.checkRead(position, length);
        try {
            this.seekToOffset(position);
            this.randomAccessFile.read(bytes, offset, length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public int readByte(int offset) {
        this.checkRead(offset, 1);
        try {
            this.seekToOffset(offset);
            return this.randomAccessFile.readByte();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public char readChar(int offset) {
        this.checkRead(offset, 2);
        try {
            this.seekToOffset(offset);
            return this.randomAccessFile.readChar();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public short readShort(int offset) {
        this.checkRead(offset, 2);
        try {
            this.seekToOffset(offset);
            return this.randomAccessFile.readShort();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readInt(int offset) {
        this.checkRead(offset, 4);
        try {
            this.seekToOffset(offset);
            return this.randomAccessFile.readInt();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long readLong(int offset) {
        this.checkRead(offset, 8);
        try {
            this.seekToOffset(offset);
            return this.randomAccessFile.readLong();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public float readFloat(int offset) {
        this.checkRead(offset, 4);
        try {
            this.seekToOffset(offset);
            return this.randomAccessFile.readFloat();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public double readDouble(int offset) {
        this.checkRead(offset, 8);
        try {
            this.seekToOffset(offset);
            return this.randomAccessFile.readDouble();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Bytes write(int position, Bytes bytes, int offset, int length) {
        this.checkWrite(position, length);
        if (bytes instanceof WrappedBytes) {
            bytes = ((WrappedBytes)bytes).root();
        }
        if (bytes.hasArray()) {
            try {
                this.seekToOffset(position);
                this.randomAccessFile.write(bytes.array(), offset, length);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.seekToOffset(position);
            byte[] writeBytes = new byte[length];
            bytes.read(offset, writeBytes, 0, length);
            this.randomAccessFile.write(writeBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes write(int position, byte[] bytes, int offset, int length) {
        this.checkWrite(position, length);
        try {
            this.seekToOffset(position);
            this.randomAccessFile.write(bytes, offset, length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes writeByte(int offset, int b) {
        this.checkWrite(offset, 1);
        try {
            this.seekToOffset(offset);
            this.randomAccessFile.writeByte(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes writeChar(int offset, char c) {
        this.checkWrite(offset, 2);
        try {
            this.seekToOffset(offset);
            this.randomAccessFile.writeChar(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes writeShort(int offset, short s) {
        this.checkWrite(offset, 2);
        try {
            this.seekToOffset(offset);
            this.randomAccessFile.writeShort(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes writeInt(int offset, int i) {
        this.checkWrite(offset, 4);
        try {
            this.seekToOffset(offset);
            this.randomAccessFile.writeInt(i);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes writeLong(int offset, long l) {
        this.checkWrite(offset, 8);
        try {
            this.seekToOffset(offset);
            this.randomAccessFile.writeLong(l);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes writeFloat(int offset, float f) {
        this.checkWrite(offset, 4);
        try {
            this.seekToOffset(offset);
            this.randomAccessFile.writeFloat(f);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes writeDouble(int offset, double d) {
        this.checkWrite(offset, 8);
        try {
            this.seekToOffset(offset);
            this.randomAccessFile.writeDouble(d);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes flush() {
        try {
            this.randomAccessFile.getFD().sync();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public void close() {
        try {
            this.randomAccessFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.close();
    }

    public void delete() {
        try {
            this.close();
            Files.delete(this.file.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

