/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.text.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.text.processors.AbstractTextProcessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ComponentName(value="Naive Paragraph")
@ComponentDescription(value="Naively extract paragraphs by looking for multiple new line characters between lines")
@SettingsClass(value=Settings.class)
public class NaiveParagraph
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings.getMinimumLineBreaks());
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("grammar/paragraph", SpanBounds.class).build();
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private int minimumLineBreaks = 1;

        public boolean validate() {
            return this.minimumLineBreaks > 0;
        }

        @Description(value="The minimum number of line breaks required between paragraphs")
        public int getMinimumLineBreaks() {
            return this.minimumLineBreaks;
        }

        public void setMinimumLineBreaks(int minimumLineBreaks) {
            this.minimumLineBreaks = minimumLineBreaks;
        }
    }

    public static class Processor
    extends AbstractTextProcessor {
        private final Pattern BREAK_REGEX;

        public Processor(int minimumLineBreaks) {
            this.BREAK_REGEX = Pattern.compile("(\\r?\\n){" + minimumLineBreaks + ",}");
        }

        protected void process(Text content) {
            Matcher m = this.BREAK_REGEX.matcher((CharSequence)content.getData());
            int prevIndex = 0;
            while (m.find()) {
                ((Annotation.Builder)content.getAnnotations().create().withType("grammar/paragraph")).withBounds((Bounds)new SpanBounds(prevIndex, m.start())).save();
                prevIndex = m.end();
            }
            ((Annotation.Builder)content.getAnnotations().create().withType("grammar/paragraph")).withBounds((Bounds)new SpanBounds(prevIndex, ((String)content.getData()).length())).save();
        }
    }
}

