/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.text.processors;

import com.optimaize.langdetect.LanguageDetector;
import com.optimaize.langdetect.LanguageDetectorBuilder;
import com.optimaize.langdetect.i18n.LdLocale;
import com.optimaize.langdetect.ngram.NgramExtractor;
import com.optimaize.langdetect.text.TextObject;
import io.annot8.common.data.bounds.ContentBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.components.AbstractComponent;
import io.annot8.components.text.processors.settings.DetectLanguageSettings;
import io.annot8.core.annotations.Annotation;
import io.annot8.core.bounds.Bounds;
import io.annot8.core.capabilities.CreatesAnnotation;
import io.annot8.core.capabilities.ProcessesContent;
import io.annot8.core.components.Processor;
import io.annot8.core.components.responses.ProcessorResponse;
import io.annot8.core.context.Context;
import io.annot8.core.data.Item;
import io.annot8.core.exceptions.BadConfigurationException;
import io.annot8.core.exceptions.MissingResourceException;
import java.util.Optional;

@ProcessesContent(value=Text.class)
@CreatesAnnotation(value="entity/language", bounds=ContentBounds.class)
public class DetectLanguage
extends AbstractComponent
implements Processor {
    private LanguageDetector languageDetector;
    private DetectLanguageSettings detectLanguageSettings;

    public void configure(Context context) throws BadConfigurationException, MissingResourceException {
        super.configure(context);
        Optional opt = context.getSettings(DetectLanguageSettings.class);
        this.detectLanguageSettings = opt.orElse(new DetectLanguageSettings());
        this.languageDetector = LanguageDetectorBuilder.create((NgramExtractor)this.detectLanguageSettings.getNgramExtractor()).withProfiles(this.detectLanguageSettings.getLanguageProfiles()).build();
    }

    public ProcessorResponse process(Item item) {
        item.getContents(Text.class).filter(t -> t.getData() != null).forEach(t -> {
            TextObject textObject = this.detectLanguageSettings.getTextObjectFactory().forText((CharSequence)t.getData());
            Optional lang = this.languageDetector.detect((CharSequence)textObject).toJavaUtil();
            if (lang.isPresent()) {
                ((Annotation.Builder)((Annotation.Builder)t.getAnnotations().create().withType("entity/language")).withBounds((Bounds)ContentBounds.getInstance()).withProperty("language", (Object)((LdLocale)lang.get()).getLanguage())).save();
            }
        });
        return ProcessorResponse.ok();
    }
}

