/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.text.processors;

import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractTextProcessor;
import io.annot8.core.capabilities.CreatesContent;
import io.annot8.core.context.Context;
import io.annot8.core.data.Item;
import io.annot8.core.exceptions.Annot8Exception;
import io.annot8.core.exceptions.BadConfigurationException;
import io.annot8.core.exceptions.MissingResourceException;
import io.annot8.core.settings.Settings;
import io.annot8.core.settings.SettingsClass;

@CreatesContent(value=Text.class)
@SettingsClass(value=CapitaliseSettings.class)
public class Capitalise
extends AbstractTextProcessor {
    private CapitaliseSettings settings = new CapitaliseSettings();

    public void configure(Context context) throws BadConfigurationException, MissingResourceException {
        super.configure(context);
        this.settings = context.getSettings(CapitaliseSettings.class).orElse(new CapitaliseSettings());
    }

    protected void process(Item item, Text content) throws Annot8Exception {
        switch (this.settings.getTextCase()) {
            case UPPERCASE: {
                item.create(Text.class).withName(content.getName() + "_upper").withData((Object)((String)content.getData()).toUpperCase()).save();
                break;
            }
            case LOWERCASE: {
                item.create(Text.class).withName(content.getName() + "_lower").withData((Object)((String)content.getData()).toLowerCase()).save();
            }
        }
    }

    public static class CapitaliseSettings
    implements Settings {
        private TextCase textCase;

        public CapitaliseSettings() {
            this.textCase = TextCase.UPPERCASE;
        }

        public CapitaliseSettings(TextCase textCase) {
            this.textCase = textCase;
        }

        public boolean validate() {
            return true;
        }

        public TextCase getTextCase() {
            return this.textCase;
        }

        public void setTextCase(TextCase textCase) {
            this.textCase = textCase;
        }
    }

    public static enum TextCase {
        UPPERCASE,
        LOWERCASE;

    }
}

