/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.stopwords.processors;

import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.stopwords.resources.Stopwords;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StopwordsProcessor
extends AbstractProcessor {
    private final Stopwords stopwords;
    private final List<String> types;

    public StopwordsProcessor(Stopwords stopwords, List<String> types) {
        this.stopwords = stopwords;
        this.types = types == null ? List.of() : types;
    }

    public ProcessorResponse process(Item item) {
        item.getContents(Text.class).forEach(c -> {
            Stream annotations = this.types.isEmpty() ? c.getAnnotations().getByBounds(SpanBounds.class) : this.types.stream().flatMap(t -> c.getAnnotations().getByBoundsAndType(SpanBounds.class, t));
            List toRemove = annotations.filter(a -> this.stopwords.isStopword(((SpanBounds)a.getBounds(SpanBounds.class).get()).getData((Content)c).orElse(""))).collect(Collectors.toList());
            if (!toRemove.isEmpty()) {
                c.getAnnotations().delete(toRemove);
            }
        });
        return ProcessorResponse.ok();
    }
}

