/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.items.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.content.Table;
import io.annot8.common.data.content.TableContent;
import io.annot8.common.data.content.Text;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@ComponentName(value="Items from Table")
@ComponentDescription(value="Converts TableContent into separate items")
@SettingsClass(value=Settings.class)
@ComponentTags(value={"item", "tables"})
public class ItemsFromTable
extends AbstractProcessorDescriptor<Processor, Settings> {
    public Capabilities capabilities() {
        SimpleCapabilities.Builder builder = new SimpleCapabilities.Builder().withProcessesContent(TableContent.class);
        if (((Settings)this.getSettings()).getContent() != null && !((Settings)this.getSettings()).getContent().isEmpty()) {
            builder = builder.withCreatesContent(Text.class);
        }
        return builder.build();
    }

    public Processor createComponent(Context context, Settings settings) {
        return new Processor(settings.getIgnore(), settings.getContent());
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private List<String> ignore = new ArrayList<String>();
        private List<String> content = new ArrayList<String>();

        public boolean validate() {
            return true;
        }

        @Description(value="A list of columns within the table that should be ignored. Columns with no column name are always ignored.")
        public List<String> getIgnore() {
            return this.ignore;
        }

        public void setIgnore(List<String> ignore) {
            this.ignore = ignore;
        }

        @Description(value="A list of columns within the table that should be converted into Text content. Other columns will be converted into properties.")
        public List<String> getContent() {
            return this.content;
        }

        public void setContent(List<String> content) {
            this.content = content;
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final List<String> ignore;
        private final List<String> content;

        public Processor(List<String> ignore, List<String> content) {
            this.ignore = ignore != null ? Collections.unmodifiableList(ignore) : Collections.emptyList();
            this.content = content != null ? Collections.unmodifiableList(content) : Collections.emptyList();
        }

        public ProcessorResponse process(Item item) {
            item.getContents(TableContent.class).forEach(tc -> {
                this.log().info("Extracting table {} ({})", (Object)tc.getId(), (Object)tc.getDescription());
                ((Table)tc.getData()).getRows().forEach(row -> {
                    Item child = item.createChild();
                    child.getProperties().set("description", (Object)("Row " + (row.getRowIndex() + 1) + " of Content " + tc.getId()));
                    child.getProperties().set("index", (Object)row.getRowIndex());
                    row.getColumnNames().forEach(column -> {
                        if (this.ignore.contains(column) || column.isBlank()) {
                            return;
                        }
                        if (this.content.contains(column)) {
                            row.getString(column).ifPresent(s -> ((Content.Builder)child.createContent(Text.class).withData(s).withDescription("Column " + column + " of Row " + (row.getRowIndex() + 1) + " of Content " + tc.getId()).withPropertyIfPresent("index", row.getIndex(column))).save());
                        } else {
                            row.getValueAt(column).ifPresent(o -> child.getProperties().set(column, o));
                        }
                    });
                });
                this.log().info("Finished extracting {} rows from table {}", (Object)((Table)tc.getData()).getRowCount(), (Object)tc.getId());
            });
            return ProcessorResponse.ok();
        }
    }
}

