/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.items.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Item;
import io.annot8.api.exceptions.BadConfigurationException;
import io.annot8.api.exceptions.ProcessingException;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ComponentName(value="Item Property from Property")
@ComponentDescription(value="Applies a regular expression to an existing item property and sets another item property based on the result")
@SettingsClass(value=Settings.class)
@ComponentTags(value={"item", "properties"})
public class ItemPropertyFromProperty
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings.getSourceKey(), settings.getTargetKey(), settings.getPattern(), settings.getGroup(), settings.getDefaultValue());
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().build();
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private String sourceKey;
        private String targetKey;
        private Pattern pattern = Pattern.compile(".*", 2);
        private int group = 0;
        private String defaultValue = null;

        @Description(value="The property key to read")
        public String getSourceKey() {
            return this.sourceKey;
        }

        public void setSourceKey(String sourceKey) {
            this.sourceKey = sourceKey;
        }

        @Description(value="The property key to write")
        public String getTargetKey() {
            return this.targetKey;
        }

        public void setTargetKey(String targetKey) {
            this.targetKey = targetKey;
        }

        @Description(value="The RegEx to apply to the property pattern")
        public Pattern getPattern() {
            return this.pattern;
        }

        public void setPattern(Pattern pattern) {
            this.pattern = pattern;
        }

        @Description(value="Which RegEx group to use for the type")
        public int getGroup() {
            return this.group;
        }

        public void setGroup(int group) {
            this.group = group;
        }

        @Description(value="The default type to use if the RegEx doesn't match or the property isn't a String (null for ignore)")
        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public boolean validate() {
            return this.sourceKey != null && this.targetKey != null && this.pattern != null && this.group >= 0;
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final String sourceKey;
        private final String targetKey;
        private final Pattern pattern;
        private final int group;
        private final String defaultValue;

        public Processor(String sourceKey, String targetKey, Pattern pattern, int group, String defaultValue) {
            if (sourceKey == null || sourceKey.isBlank()) {
                throw new BadConfigurationException("Source key can't be null or blank");
            }
            if (targetKey == null || targetKey.isBlank()) {
                throw new BadConfigurationException("Target key can't be null or blank");
            }
            if (pattern == null) {
                throw new BadConfigurationException("Pattern must be set");
            }
            if (group < 0) {
                throw new BadConfigurationException("Group number must be 0 or greater");
            }
            if (defaultValue == null) {
                this.log().info("No default value set - target property will not be set if pattern does not match");
            }
            this.sourceKey = sourceKey;
            this.targetKey = targetKey;
            this.pattern = pattern;
            this.group = group;
            this.defaultValue = defaultValue;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ProcessorResponse process(Item item) {
            if (item.getProperties().has(this.sourceKey)) {
                String s = item.getProperties().get(this.sourceKey).get().toString();
                Matcher m = this.pattern.matcher(s);
                if (m.matches()) {
                    try {
                        String t = m.group(this.group);
                        if (t == null) return ProcessorResponse.ok();
                        item.getProperties().set(this.targetKey, (Object)t);
                        return ProcessorResponse.ok();
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new ProcessingException("Group number out of bounds for provided pattern", (Throwable)e);
                    }
                } else {
                    if (this.defaultValue == null) return ProcessorResponse.ok();
                    item.getProperties().set(this.targetKey, (Object)this.defaultValue);
                }
                return ProcessorResponse.ok();
            } else {
                if (this.defaultValue == null) return ProcessorResponse.ok();
                item.getProperties().set(this.targetKey, (Object)this.defaultValue);
            }
            return ProcessorResponse.ok();
        }
    }
}

