/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.items.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import jakarta.json.bind.annotation.JsonbCreator;
import jakarta.json.bind.annotation.JsonbProperty;

@ComponentName(value="Item Property from Parameter")
@ComponentDescription(value="Explicitly sets a property on the item")
@SettingsClass(value=Settings.class)
@ComponentTags(value={"item", "properties"})
public class ItemPropertyFromParameter
extends AbstractProcessorDescriptor<Processor, Settings> {
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().build();
    }

    public Processor createComponent(Context context, Settings settings) {
        return new Processor(settings.getKey(), settings.getValue());
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private String key;
        private Object value;

        public Settings() {
        }

        @JsonbCreator
        public Settings(@JsonbProperty(value="key") String key, @JsonbProperty(value="value") Object value) {
            this.key = key;
            this.value = value;
        }

        public boolean validate() {
            return this.key != null;
        }

        @Description(value="The key of the property to set")
        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        @Description(value="The value of the property to set, or null to remove the property")
        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final String key;
        private final Object value;

        public Processor(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public ProcessorResponse process(Item item) {
            if (this.key == null || this.key.isEmpty()) {
                return ProcessorResponse.processingError();
            }
            if (this.value == null) {
                item.getProperties().remove(this.key);
            } else {
                item.getProperties().set(this.key, this.value);
            }
            return ProcessorResponse.ok();
        }
    }
}

