/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.items.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Item;
import io.annot8.api.exceptions.BadConfigurationException;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;

@ComponentName(value="Item Property as Date Time")
@ComponentDescription(value="Converts an existing Item Property into a date time")
@SettingsClass(value=Settings.class)
@ComponentTags(value={"item", "properties", "temporal", "date", "time"})
public class ItemPropertyAsDateTime
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings);
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().build();
    }

    public static enum DateTimeType {
        DATE,
        TIME,
        DATETIME,
        ZONED_DATETIME,
        OFFSET_DATETIME;

    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private String key = "date";
        private String dateTimeFormat = "yyyy-MM-dd";
        private DateTimeType dateTimeType = DateTimeType.DATETIME;
        private boolean errorOnUnparseable = true;

        public boolean validate() {
            return this.key != null && this.dateTimeFormat != null && this.dateTimeType != null;
        }

        @Description(value="The property key to convert")
        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        @Description(value="The format to use when parsing")
        public String getDateTimeFormat() {
            return this.dateTimeFormat;
        }

        public void setDateTimeFormat(String dateTimeFormat) {
            this.dateTimeFormat = dateTimeFormat;
        }

        @Description(value="The type of date time to create")
        public DateTimeType getDateTimeType() {
            return this.dateTimeType;
        }

        public void setDateTimeType(DateTimeType dateTimeType) {
            this.dateTimeType = dateTimeType;
        }

        @Description(value="If false, then dates that can't be parsed will be discarded. If true, then unparseable dates will cause an item error to be returned.")
        public boolean isErrorOnUnparseable() {
            return this.errorOnUnparseable;
        }

        public void setErrorOnUnparseable(boolean errorOnUnparseable) {
            this.errorOnUnparseable = errorOnUnparseable;
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final Settings settings;
        private final DateTimeFormatter dateTimeFormatter;

        public Processor(Settings settings) {
            this.settings = settings;
            try {
                this.dateTimeFormatter = DateTimeFormatter.ofPattern(settings.getDateTimeFormat());
            }
            catch (IllegalArgumentException e) {
                throw new BadConfigurationException("Provided date time format could not be parsed", (Throwable)e);
            }
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public ProcessorResponse process(Item item) {
            if (item.getProperties().has(this.settings.getKey())) {
                block23: {
                    o = item.getProperties().get(this.settings.getKey()).get();
                    temporal /* !! */  = null;
                    if (o instanceof TemporalAccessor) {
                        try {
                            switch (1.$SwitchMap$io$annot8$components$items$processors$ItemPropertyAsDateTime$DateTimeType[this.settings.getDateTimeType().ordinal()]) {
                                case 1: {
                                    temporal /* !! */  = LocalDate.from((TemporalAccessor)o);
                                    break;
                                }
                                case 2: {
                                    temporal /* !! */  = LocalTime.from((TemporalAccessor)o);
                                    break;
                                }
                                case 3: {
                                    temporal /* !! */  = LocalDateTime.from((TemporalAccessor)o);
                                    break;
                                }
                                case 4: {
                                    temporal /* !! */  = OffsetDateTime.from((TemporalAccessor)o);
                                    break;
                                }
                                case 5: {
                                    temporal /* !! */  = ZonedDateTime.from((TemporalAccessor)o);
                                }
                            }
                        }
                        catch (DateTimeException e) {
                            this.log().warn("Could not convert property {} from {} ({})", new Object[]{this.settings.getKey(), o.getClass().getName(), e.getMessage()});
                            if (!this.settings.isErrorOnUnparseable()) ** GOTO lbl48
                            return ProcessorResponse.itemError((Exception[])new Exception[]{e});
                        }
                    } else {
                        s = o.toString();
                        try {
                            switch (1.$SwitchMap$io$annot8$components$items$processors$ItemPropertyAsDateTime$DateTimeType[this.settings.getDateTimeType().ordinal()]) {
                                case 1: {
                                    temporal /* !! */  = LocalDate.parse(s, this.dateTimeFormatter);
                                    break;
                                }
                                case 2: {
                                    temporal /* !! */  = LocalTime.parse(s, this.dateTimeFormatter);
                                    break;
                                }
                                case 3: {
                                    temporal /* !! */  = LocalDateTime.parse(s, this.dateTimeFormatter);
                                    break;
                                }
                                case 5: {
                                    temporal /* !! */  = ZonedDateTime.parse(s, this.dateTimeFormatter);
                                    break;
                                }
                                case 4: {
                                    temporal /* !! */  = OffsetDateTime.parse(s, this.dateTimeFormatter);
                                }
                            }
                        }
                        catch (DateTimeParseException e) {
                            this.log().warn("Could not parse {} from property {} ({})", new Object[]{s, this.settings.getKey(), e.getMessage()});
                            if (!this.settings.isErrorOnUnparseable()) break block23;
                            return ProcessorResponse.itemError((Exception[])new Exception[]{e});
                        }
                    }
                }
                if (temporal /* !! */  != null) {
                    item.getProperties().set(this.settings.getKey(), (Object)temporal /* !! */ );
                } else {
                    item.getProperties().remove(this.settings.getKey());
                }
            }
            return ProcessorResponse.ok();
        }
    }
}

