/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.items.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import java.util.List;

@ComponentName(value="Item Property as Boolean")
@ComponentDescription(value="Converts an existing Item Property into a Boolean")
@SettingsClass(value=Settings.class)
@ComponentTags(value={"item", "properties", "boolean"})
public class ItemPropertyAsBoolean
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings);
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().build();
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private String key = "key";
        private List<Object> trueValues = List.of("true", "yes", Integer.valueOf(1));

        public boolean validate() {
            return this.key != null && this.trueValues != null;
        }

        @Description(value="The property key to convert")
        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        @Description(value="The list of values to accept as true. Comparison is done both on the original property value, and on the lower case String representation of it.")
        public List<Object> getTrueValues() {
            return this.trueValues;
        }

        public void setTrueValues(List<Object> trueValues) {
            this.trueValues = trueValues;
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final Settings settings;

        public Processor(Settings settings) {
            this.settings = settings;
        }

        public ProcessorResponse process(Item item) {
            Object o;
            if (item.getProperties().has(this.settings.getKey()) && !Boolean.class.isAssignableFrom((o = item.getProperties().get(this.settings.getKey()).get()).getClass())) {
                item.getProperties().set(this.settings.getKey(), (Object)(this.settings.getTrueValues().contains(o) || this.settings.getTrueValues().contains(o.toString().strip().toLowerCase()) ? 1 : 0));
            }
            return ProcessorResponse.ok();
        }
    }
}

