/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.items.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@ComponentName(value="Filter Item Content")
@ComponentDescription(value="Filter Content of a given type")
@SettingsClass(value=Settings.class)
@ComponentTags(value={"item", "content", "filter"})
public class FilterItemContent
extends AbstractProcessorDescriptor<Processor, Settings> {
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().build();
    }

    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings.getContentClasses(), settings.isDiscardMatching());
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private List<String> contentClasses = new ArrayList<String>();
        private boolean discardMatching = true;

        public boolean validate() {
            return this.contentClasses != null && !this.contentClasses.isEmpty();
        }

        @Description(value="A list of Content class names to filter by")
        public List<String> getContentClasses() {
            return this.contentClasses;
        }

        public void setContentClasses(List<String> contentClasses) {
            this.contentClasses = contentClasses;
        }

        @Description(value="If true, then matching Content is discarded. Otherwise, non-matching Content are discarded.")
        public boolean isDiscardMatching() {
            return this.discardMatching;
        }

        public void setDiscardMatching(boolean discardMatching) {
            this.discardMatching = discardMatching;
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final List<Class<Content<?>>> contentClasses = new ArrayList();
        private final boolean discardMatching;

        public Processor(List<String> contentClasses, boolean discardMatching) {
            contentClasses.forEach(s -> {
                try {
                    Class<?> c = Class.forName(s);
                    if (Content.class.isAssignableFrom(c)) {
                        this.contentClasses.add(c);
                    } else {
                        this.log().warn("Class {} is not a sub-class of Content", s);
                    }
                }
                catch (ClassNotFoundException e) {
                    this.log().warn("Class {} could not be found", s);
                }
            });
            this.discardMatching = discardMatching;
        }

        public ProcessorResponse process(Item item) {
            Set<Content> matching = this.contentClasses.stream().flatMap(arg_0 -> ((Item)item).getContents(arg_0)).collect(Collectors.toSet());
            if (this.discardMatching) {
                this.log().info("Discarding {} Contents that match one of the given classes", (Object)matching.size());
                matching.forEach(arg_0 -> ((Item)item).removeContent(arg_0));
            } else {
                List<Content> nonMatching = item.getContents().filter(c -> !matching.contains(c)).collect(Collectors.toList());
                this.log().info("Discarding {} Contents that don't match any of the given classes", (Object)nonMatching.size());
                nonMatching.forEach(arg_0 -> ((Item)item).removeContent(arg_0));
            }
            return ProcessorResponse.ok();
        }
    }
}

