/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.grouping.processors;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import io.annot8.api.annotations.Annotation;
import io.annot8.api.annotations.Group;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.api.stores.GroupStore;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractTextProcessor;
import java.util.Optional;

@ComponentName(value="Group by Type and Value")
@ComponentDescription(value="Group annotations where their type and covered text (value) are the same")
public class GroupByTypeAndValue
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesAnnotations("*", SpanBounds.class).withCreatesGroups("exactMatches").build();
    }

    public static class Processor
    extends AbstractTextProcessor {
        public static final String TYPE = "exactMatches";
        private static final String ROLE = "as";

        protected void process(Text content) {
            HashMultimap map = HashMultimap.create();
            content.getAnnotations().getByBounds(SpanBounds.class).forEach(arg_0 -> this.lambda$process$1(content, (SetMultimap)map, arg_0));
            GroupStore groupStore = content.getItem().getGroups();
            map.asMap().values().forEach(annotations -> {
                Group.Builder builder = (Group.Builder)groupStore.create().withType(TYPE);
                annotations.forEach(a -> builder.withAnnotation(ROLE, a));
                builder.save();
            });
        }

        private String toKey(String type, String covered) {
            return type + ":" + covered;
        }

        private /* synthetic */ void lambda$process$1(Text content, SetMultimap map, Annotation a) {
            Optional optional = content.getText(a);
            optional.ifPresent(covered -> {
                String key = this.toKey(a.getType(), (String)covered);
                map.put((Object)key, (Object)a);
            });
        }
    }
}

