/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.elasticsearch;

import io.annot8.api.settings.Description;
import io.annot8.api.settings.Settings;
import jakarta.json.bind.annotation.JsonbTransient;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.elasticsearch.common.Strings;

public class ElasticsearchSettings
implements Settings {
    private String hostname = "localhost";
    private int port = 9200;
    private String scheme = "http";
    private String index = "baleen";
    private boolean deleteIndex = false;
    private boolean forceString = false;
    private String username = null;
    private String password = null;

    public ElasticsearchSettings() {
    }

    public ElasticsearchSettings(String hostname, int port, String scheme, String index, boolean deleteIndex, boolean forceString) {
        this.hostname = hostname;
        this.port = port;
        this.scheme = scheme;
        this.index = index;
        this.deleteIndex = deleteIndex;
        this.forceString = forceString;
    }

    public ElasticsearchSettings(String hostname, int port, String scheme, String index, boolean deleteIndex, boolean forceString, String username, String password) {
        this.hostname = hostname;
        this.port = port;
        this.scheme = scheme;
        this.index = index;
        this.deleteIndex = deleteIndex;
        this.forceString = forceString;
        this.username = username;
        this.password = password;
    }

    public boolean validate() {
        return this.hostname != null && !this.hostname.isEmpty() && this.port >= 0 && this.port <= 65535 && this.scheme != null && !this.scheme.isEmpty() && this.index != null && !this.index.isEmpty();
    }

    @JsonbTransient
    public HttpHost host() {
        return new HttpHost(this.hostname, this.port, this.scheme);
    }

    @Description(value="The hostname of the Elasticsearch server", defaultValue="localhost")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Description(value="The port of the Elasticsearch server", defaultValue="9200")
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Description(value="The scheme over which to communicate with the Elasticsearch server (e.g. http or https)", defaultValue="http")
    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    @Description(value="The Elasticsearch index to use", defaultValue="baleen")
    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    @Description(value="Should the Elasticsearch be deleted when the processor is initialised?", defaultValue="false")
    public boolean isDeleteIndex() {
        return this.deleteIndex;
    }

    public void setDeleteIndex(boolean deleteIndex) {
        this.deleteIndex = deleteIndex;
    }

    @Description(value="Should string representations of properties be used rather than the raw Java object?", defaultValue="false")
    public boolean isForceString() {
        return this.forceString;
    }

    public void setForceString(boolean forceString) {
        this.forceString = forceString;
    }

    @Description(value="If username and password are provided, then these are used to authenticate the connection to Elasticsearch")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Description(value="If username and password are provided, then these are used to authenticate the connection to Elasticsearch")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public CredentialsProvider credentials() {
        if (Strings.isNullOrEmpty((String)this.getUsername()) || Strings.isNullOrEmpty((String)this.getPassword())) {
            return null;
        }
        BasicCredentialsProvider cp = new BasicCredentialsProvider();
        cp.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.getUsername(), this.getPassword()));
        return cp;
    }
}

