/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.comms.processors;

import com.google.i18n.phonenumbers.PhoneNumberMatch;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.text.processors.AbstractTextProcessor;

@ComponentName(value="Telephone Number")
@ComponentDescription(value="Extract Telephone numbers from text")
@ComponentTags(value={"communications", "telephone"})
@SettingsClass(value=Settings.class)
public class Telephone
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings);
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/phonenumber", SpanBounds.class).build();
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private String defaultRegion = null;
        private PhoneNumberUtil.Leniency leniency = PhoneNumberUtil.Leniency.VALID;

        public Settings() {
        }

        public Settings(String defaultRegion, PhoneNumberUtil.Leniency leniency) {
            this.defaultRegion = defaultRegion;
            this.leniency = leniency;
        }

        public boolean validate() {
            return this.leniency != null && (this.defaultRegion == null || PhoneNumberUtil.getInstance().getSupportedRegions().contains(this.defaultRegion));
        }

        @Description(value="Two letter country code to be used as the default region for phone numbers where the number is not a full international phone number. Set to null if you only want to extract full international phone numbers.")
        public String getDefaultRegion() {
            return this.defaultRegion;
        }

        public void setDefaultRegion(String defaultRegion) {
            this.defaultRegion = defaultRegion;
        }

        @Description(value="The leniency to use when parsing numbers")
        public PhoneNumberUtil.Leniency getLeniency() {
            return this.leniency;
        }

        public void setLeniency(PhoneNumberUtil.Leniency leniency) {
            this.leniency = leniency;
        }
    }

    public static class Processor
    extends AbstractTextProcessor {
        private final String defaultRegion;
        private final PhoneNumberUtil.Leniency leniency;

        public Processor(Settings settings) {
            this.defaultRegion = settings.getDefaultRegion();
            this.leniency = settings.getLeniency();
        }

        protected void process(Text content) {
            for (PhoneNumberMatch match : PhoneNumberUtil.getInstance().findNumbers((CharSequence)content.getData(), this.defaultRegion, this.leniency, Long.MAX_VALUE)) {
                ((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)content.getAnnotations().create().withBounds((Bounds)new SpanBounds(match.start(), match.end())).withType("entity/phonenumber")).withProperty("value", (Object)PhoneNumberUtil.getInstance().format(match.number(), PhoneNumberUtil.PhoneNumberFormat.E164))).withProperty("subtype", (Object)PhoneNumberUtil.getInstance().getNumberType(match.number()))).save();
            }
        }
    }
}

