/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.comms.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractRegexProcessor;
import java.util.regex.Pattern;

@ComponentName(value="US Telephone Number")
@ComponentDescription(value="Extract valid US-style Telephone numbers (e.g. 1-800-CALLME) from text")
@ComponentTags(value={"communications", "telephone", "text"})
public class USTelephone
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/phonenumber", SpanBounds.class).build();
    }

    public static class Processor
    extends AbstractRegexProcessor {
        public Processor() {
            super(Pattern.compile("((\\(?\\+?1\\)?[-. ])?\\(?([2-9]|two|three|four|five|six|seven|eight|nine)([0-9]|zero|one|two|three|four|five|six|seven|eight|nine){2}\\)?[-. ]([2-9]|two|three|four|five|six|seven|eight|nine)([0-9]|zero|one|two|three|four|five|six|seven|eight|nine){2}[-. ]([0-9]|zero|one|two|three|four|five|six|seven|eight|nine){4}|1-800-[A-Z]{7})\\b", 2), 0, "entity/phonenumber");
        }
    }
}

