/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.starter.configuration.client;

import io.allune.quickfixj.spring.boot.starter.application.EventPublisherApplicationAdapter;
import io.allune.quickfixj.spring.boot.starter.configuration.QuickFixJBootProperties;
import io.allune.quickfixj.spring.boot.starter.connection.ConnectorManager;
import io.allune.quickfixj.spring.boot.starter.connection.SessionSettingsLocator;
import io.allune.quickfixj.spring.boot.starter.exception.ConfigurationException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.quickfixj.jmx.JmxExporter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import quickfix.Application;
import quickfix.CachedFileStoreFactory;
import quickfix.CompositeLogFactory;
import quickfix.ConfigError;
import quickfix.Connector;
import quickfix.DefaultMessageFactory;
import quickfix.ExecutorFactory;
import quickfix.FileLogFactory;
import quickfix.FileStoreFactory;
import quickfix.Initiator;
import quickfix.JdbcLogFactory;
import quickfix.JdbcStoreFactory;
import quickfix.LogFactory;
import quickfix.MemoryStoreFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.NoopStoreFactory;
import quickfix.SLF4JLogFactory;
import quickfix.ScreenLogFactory;
import quickfix.SessionSettings;
import quickfix.SleepycatStoreFactory;
import quickfix.SocketInitiator;
import quickfix.ThreadedSocketInitiator;

@Configuration
@EnableConfigurationProperties(value={QuickFixJBootProperties.class})
@Deprecated
public class QuickFixJClientConfiguration {
    private static final String SYSTEM_VARIABLE_QUICKFIXJ_CLIENT_CONFIG = "quickfixj.client.config";
    private static final String QUICKFIXJ_CLIENT_CONFIG = "quickfixj-client.cfg";

    @Bean
    @ConditionalOnClass(value={SessionSettings.class})
    @ConditionalOnMissingBean(name={"clientSessionSettings"})
    public SessionSettings clientSessionSettings(SessionSettingsLocator clientSessionSettingsLocator, QuickFixJBootProperties properties) {
        if (StringUtils.isNotEmpty((CharSequence)properties.getClient().getConfigString())) {
            return clientSessionSettingsLocator.loadSettingsFromString(properties.getClient().getConfigString());
        }
        return clientSessionSettingsLocator.loadSettings(properties.getClient().getConfig(), System.getProperty(SYSTEM_VARIABLE_QUICKFIXJ_CLIENT_CONFIG), "file:./quickfixj-client.cfg", "classpath:/quickfixj-client.cfg");
    }

    @Bean
    @ConditionalOnClass(value={Application.class})
    @ConditionalOnMissingBean(name={"clientApplication"})
    public Application clientApplication(ApplicationEventPublisher applicationEventPublisher) {
        return new EventPublisherApplicationAdapter(applicationEventPublisher);
    }

    @Bean
    @ConditionalOnClass(value={MessageFactory.class})
    @ConditionalOnMissingBean(name={"clientMessageFactory"})
    public MessageFactory clientMessageFactory() {
        return new DefaultMessageFactory();
    }

    @Bean
    @ConditionalOnClass(value={ExecutorFactory.class})
    @ConditionalOnMissingBean(name={"clientExecutorFactory"})
    @ConditionalOnProperty(prefix="quickfixj.client.concurrent", name={"useDefaultExecutorFactory"}, havingValue="true")
    public ExecutorFactory clientExecutorFactory(final Executor clientTaskExecutor) {
        return new ExecutorFactory(){

            public Executor getLongLivedExecutor() {
                return clientTaskExecutor;
            }

            public Executor getShortLivedExecutor() {
                return clientTaskExecutor;
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(name={"clientTaskExecutor"})
    @ConditionalOnProperty(prefix="quickfixj.client.concurrent", name={"useDefaultExecutorFactory"}, havingValue="true")
    public Executor clientTaskExecutor(QuickFixJBootProperties properties) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setQueueCapacity(properties.getClient().getConcurrent().getQueueCapacity());
        executor.setCorePoolSize(properties.getClient().getConcurrent().getCorePoolSize());
        executor.setMaxPoolSize(properties.getClient().getConcurrent().getMaxPoolSize());
        executor.setAllowCoreThreadTimeOut(properties.getClient().getConcurrent().isAllowCoreThreadTimeOut());
        executor.setKeepAliveSeconds(properties.getClient().getConcurrent().getKeepAliveSeconds());
        executor.setWaitForTasksToCompleteOnShutdown(properties.getClient().getConcurrent().isWaitForTasksToCompleteOnShutdown());
        executor.setAwaitTerminationSeconds(properties.getClient().getConcurrent().getAwaitTerminationSeconds());
        executor.setThreadNamePrefix(properties.getClient().getConcurrent().getThreadNamePrefix());
        return executor;
    }

    @Bean
    public ConnectorManager clientConnectorManager(Initiator clientInitiator, QuickFixJBootProperties properties) {
        ConnectorManager connectorManager = new ConnectorManager((Connector)clientInitiator);
        if (properties.getClient() != null) {
            connectorManager.setAutoStartup(properties.getClient().isAutoStartup());
            connectorManager.setPhase(properties.getClient().getPhase());
            connectorManager.setForceDisconnect(properties.getClient().isForceDisconnect());
        }
        return connectorManager;
    }

    @Bean
    @ConditionalOnProperty(prefix="quickfixj.client", name={"jmx-enabled"}, havingValue="true")
    @ConditionalOnClass(value={JmxExporter.class})
    @ConditionalOnSingleCandidate(value=Initiator.class)
    @ConditionalOnMissingBean(name={"clientInitiatorMBean"})
    public ObjectName clientInitiatorMBean(Initiator clientInitiator) {
        try {
            JmxExporter exporter = new JmxExporter();
            exporter.setRegistrationBehavior(2);
            return exporter.register((Connector)clientInitiator);
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    @Bean
    public SessionSettingsLocator clientSessionSettingsLocator(ResourceLoader resourceLoader) {
        return new SessionSettingsLocator(resourceLoader);
    }

    @Configuration
    @ConditionalOnClass(value={Initiator.class})
    @ConditionalOnMissingBean(name={"clientInitiator"})
    @ConditionalOnProperty(prefix="quickfixj.client.concurrent", name={"enabled"}, havingValue="true")
    public static class ThreadedSocketInitiatorConfiguration {
        @Bean
        public Initiator clientInitiator(Application clientApplication, MessageStoreFactory clientMessageStoreFactory, SessionSettings clientSessionSettings, LogFactory clientLogFactory, MessageFactory clientMessageFactory, Optional<ExecutorFactory> clientExecutorFactory) throws ConfigError {
            ThreadedSocketInitiator socketInitiator = (ThreadedSocketInitiator)((ThreadedSocketInitiator.Builder)((ThreadedSocketInitiator.Builder)((ThreadedSocketInitiator.Builder)((ThreadedSocketInitiator.Builder)((ThreadedSocketInitiator.Builder)ThreadedSocketInitiator.newBuilder().withApplication(clientApplication)).withMessageStoreFactory(clientMessageStoreFactory)).withSettings(clientSessionSettings)).withLogFactory(clientLogFactory)).withMessageFactory(clientMessageFactory)).build();
            clientExecutorFactory.ifPresent(arg_0 -> ((ThreadedSocketInitiator)socketInitiator).setExecutorFactory(arg_0));
            return socketInitiator;
        }
    }

    @Configuration
    @ConditionalOnClass(value={Initiator.class})
    @ConditionalOnMissingBean(name={"clientInitiator"})
    @ConditionalOnProperty(prefix="quickfixj.client.concurrent", name={"enabled"}, havingValue="false", matchIfMissing=true)
    public static class SocketInitiatorConfiguration {
        @Bean
        public Initiator clientInitiator(Application clientApplication, MessageStoreFactory clientMessageStoreFactory, SessionSettings clientSessionSettings, LogFactory clientLogFactory, MessageFactory clientMessageFactory, Optional<ExecutorFactory> clientExecutorFactory) throws ConfigError {
            SocketInitiator socketInitiator = (SocketInitiator)((SocketInitiator.Builder)((SocketInitiator.Builder)((SocketInitiator.Builder)((SocketInitiator.Builder)((SocketInitiator.Builder)SocketInitiator.newBuilder().withApplication(clientApplication)).withMessageStoreFactory(clientMessageStoreFactory)).withSettings(clientSessionSettings)).withLogFactory(clientLogFactory)).withMessageFactory(clientMessageFactory)).build();
            clientExecutorFactory.ifPresent(arg_0 -> ((SocketInitiator)socketInitiator).setExecutorFactory(arg_0));
            return socketInitiator;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(name={"clientLogFactory"})
    @ConditionalOnProperty(prefix="quickfixj.client", name={"log-factory"}, havingValue="compositelog")
    static class CompositeLogFactoryConfiguration {
        CompositeLogFactoryConfiguration() {
        }

        @Bean
        public LogFactory clientLogFactory(List<LogFactory> logFactories) {
            if (logFactories == null || logFactories.isEmpty()) {
                throw new ConfigurationException("The CompositeLogFactory requires at least one LogFactory bean defined in your application");
            }
            return new CompositeLogFactory(logFactories.toArray(new LogFactory[0]));
        }
    }

    @Configuration
    @ConditionalOnClass(value={LogFactory.class})
    @ConditionalOnMissingBean(name={"clientLogFactory"})
    @ConditionalOnProperty(prefix="quickfixj.client", name={"log-factory"}, havingValue="screen", matchIfMissing=true)
    static class ScreenLogFactoryConfiguration {
        ScreenLogFactoryConfiguration() {
        }

        @Bean
        public LogFactory clientLogFactory(SessionSettings clientSessionSettings) {
            return new ScreenLogFactory(clientSessionSettings);
        }
    }

    @Configuration
    @ConditionalOnClass(value={LogFactory.class})
    @ConditionalOnMissingBean(name={"clientLogFactory"})
    @ConditionalOnProperty(prefix="quickfixj.client", name={"log-factory"}, havingValue="slf4j")
    static class Slf4jLogFactoryConfiguration {
        Slf4jLogFactoryConfiguration() {
        }

        @Bean
        public LogFactory clientLogFactory(SessionSettings clientSessionSettings) {
            return new SLF4JLogFactory(clientSessionSettings);
        }
    }

    @Configuration
    @ConditionalOnClass(value={LogFactory.class})
    @ConditionalOnMissingBean(name={"clientLogFactory"})
    @ConditionalOnProperty(prefix="quickfixj.client", name={"log-factory"}, havingValue="jdbc")
    static class JdbcLogFactoryConfiguration {
        JdbcLogFactoryConfiguration() {
        }

        @Bean
        public LogFactory clientLogFactory(SessionSettings clientSessionSettings) {
            return new JdbcLogFactory(clientSessionSettings);
        }
    }

    @Configuration
    @ConditionalOnClass(value={LogFactory.class})
    @ConditionalOnMissingBean(name={"clientLogFactory"})
    @ConditionalOnProperty(prefix="quickfixj.client", name={"log-factory"}, havingValue="file")
    static class FileLogFactoryConfiguration {
        FileLogFactoryConfiguration() {
        }

        @Bean
        public LogFactory clientLogFactory(SessionSettings clientSessionSettings) {
            return new FileLogFactory(clientSessionSettings);
        }
    }

    @Configuration
    @ConditionalOnClass(value={MessageStoreFactory.class})
    @ConditionalOnMissingBean(name={"clientMessageStoreFactory"})
    @ConditionalOnProperty(prefix="quickfixj.client", name={"message-store-factory"}, havingValue="sleepycat")
    static class SleepycatMessageStoreFactoryConfiguration {
        SleepycatMessageStoreFactoryConfiguration() {
        }

        @Bean
        public MessageStoreFactory clientMessageStoreFactory(SessionSettings clientSessionSettings) {
            return new SleepycatStoreFactory(clientSessionSettings);
        }
    }

    @Configuration
    @ConditionalOnClass(value={MessageStoreFactory.class})
    @ConditionalOnMissingBean(name={"clientMessageStoreFactory"})
    @ConditionalOnProperty(prefix="quickfixj.client", name={"message-store-factory"}, havingValue="noop")
    static class NoopMessageStoreFactoryConfiguration {
        NoopMessageStoreFactoryConfiguration() {
        }

        @Bean
        public MessageStoreFactory clientMessageStoreFactory() {
            return new NoopStoreFactory();
        }
    }

    @Configuration
    @ConditionalOnClass(value={MessageStoreFactory.class})
    @ConditionalOnMissingBean(name={"clientMessageStoreFactory"})
    @ConditionalOnProperty(prefix="quickfixj.client", name={"message-store-factory"}, havingValue="memory", matchIfMissing=true)
    static class MemoryMessageStoreFactoryConfiguration {
        MemoryMessageStoreFactoryConfiguration() {
        }

        @Bean
        public MessageStoreFactory clientMessageStoreFactory() {
            return new MemoryStoreFactory();
        }
    }

    @Configuration
    @ConditionalOnClass(value={MessageStoreFactory.class})
    @ConditionalOnMissingBean(name={"clientMessageStoreFactory"})
    @ConditionalOnProperty(prefix="quickfixj.client", name={"message-store-factory"}, havingValue="jdbc")
    static class JdbcMessageStoreFactoryConfiguration {
        JdbcMessageStoreFactoryConfiguration() {
        }

        @Bean
        public MessageStoreFactory clientMessageStoreFactory(SessionSettings clientSessionSettings) {
            return new JdbcStoreFactory(clientSessionSettings);
        }
    }

    @Configuration
    @ConditionalOnClass(value={MessageStoreFactory.class})
    @ConditionalOnMissingBean(name={"clientMessageStoreFactory"})
    @ConditionalOnProperty(prefix="quickfixj.client", name={"message-store-factory"}, havingValue="file")
    static class FileMessageStoreFactoryConfiguration {
        FileMessageStoreFactoryConfiguration() {
        }

        @Bean
        public MessageStoreFactory clientMessageStoreFactory(SessionSettings clientSessionSettings) {
            return new FileStoreFactory(clientSessionSettings);
        }
    }

    @Configuration
    @ConditionalOnClass(value={MessageStoreFactory.class})
    @ConditionalOnMissingBean(name={"clientMessageStoreFactory"})
    @ConditionalOnProperty(prefix="quickfixj.client", name={"message-store-factory"}, havingValue="cachedfile")
    static class CachedFileMessageStoreFactoryConfiguration {
        CachedFileMessageStoreFactoryConfiguration() {
        }

        @Bean
        public MessageStoreFactory clientMessageStoreFactory(SessionSettings clientSessionSettings) {
            return new CachedFileStoreFactory(clientSessionSettings);
        }
    }
}

