/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.intellij;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import ie.corballis.fixtures.intellij.PsiClassVisitor;
import ie.corballis.fixtures.intellij.PsiClassVisitorAction;
import org.jetbrains.annotations.NotNull;

public class JsonFixturesLineMarkersPass
extends TextEditorHighlightingPass
implements PsiClassVisitorAction {
    private static final Key<Object> KEY = new Key("JsonFixtures");
    private final Project project;
    private final Document document;
    private final MarkupModel model;

    protected JsonFixturesLineMarkersPass(Project project, Document document, MarkupModel model) {
        super(project, document);
        this.project = project;
        this.document = document;
        this.model = model;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
    }

    public void doApplyInformationToEditor() {
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.project).getPsiFile(this.document);
        if (psiFile == null) {
            return;
        }
        psiFile.acceptChildren((PsiElementVisitor)new PsiClassVisitor(this));
    }

    @Override
    public void execute(PsiClass psiClass) {
        this.clearMarkersFrom(this.model);
        for (PsiField field : psiClass.getAllFields()) {
            for (PsiAnnotation annotation : field.getModifierList().getAnnotations()) {
                PsiAnnotationParameterList parameterList = annotation.getParameterList();
                System.out.println(annotation);
                System.out.println(parameterList);
            }
        }
    }

    private void clearMarkersFrom(MarkupModel model) {
        for (RangeHighlighter each : model.getAllHighlighters()) {
            if (each.getUserData(KEY) == null) continue;
            model.removeHighlighter(each);
        }
    }
}

