package io.k8s.api.networking.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** IngressList is a collection of Ingress. */
final case class IngressList(
  items : Seq[io.k8s.api.networking.v1.Ingress],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("networking.k8s.io", "IngressList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.networking.v1.Ingress]) : IngressList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.networking.v1.Ingress*) : IngressList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.networking.v1.Ingress] => Seq[io.k8s.api.networking.v1.Ingress]) : IngressList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : IngressList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : IngressList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = IngressList.encoder.apply(this)
}

object IngressList {

    implicit val encoder : Encoder[io.k8s.api.networking.v1.IngressList] = new Encoder[io.k8s.api.networking.v1.IngressList] {
        def apply[T : Builder](o: io.k8s.api.networking.v1.IngressList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[IngressList] = new Decoder[IngressList] {
      def apply[T : Reader](t: T): Either[String, IngressList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.networking.v1.Ingress]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield IngressList (
          items = items,
          metadata = metadata
        )
    }
}

