package io.k8s.api.networking.v1

import dev.hnaderi.k8s.utils._

/** IngressBackend describes all endpoints for a given service and port. */
final case class IngressBackend(
  resource : Option[io.k8s.api.core.v1.TypedLocalObjectReference] = None,
  service : Option[io.k8s.api.networking.v1.IngressServiceBackend] = None
) {

  /** Returns a new data with resource set to new value */
  def withResource(value: io.k8s.api.core.v1.TypedLocalObjectReference) : IngressBackend = copy(resource = Some(value))
  /** if resource has a value, transforms to the result of function*/
  def mapResource(f: io.k8s.api.core.v1.TypedLocalObjectReference => io.k8s.api.core.v1.TypedLocalObjectReference) : IngressBackend = copy(resource = resource.map(f))

  /** Returns a new data with service set to new value */
  def withService(value: io.k8s.api.networking.v1.IngressServiceBackend) : IngressBackend = copy(service = Some(value))
  /** if service has a value, transforms to the result of function*/
  def mapService(f: io.k8s.api.networking.v1.IngressServiceBackend => io.k8s.api.networking.v1.IngressServiceBackend) : IngressBackend = copy(service = service.map(f))
}

object IngressBackend {

    implicit val encoder : Encoder[io.k8s.api.networking.v1.IngressBackend] = new Encoder[io.k8s.api.networking.v1.IngressBackend] {
        def apply[T : Builder](o: io.k8s.api.networking.v1.IngressBackend) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("resource", o.resource)
            .write("service", o.service)
            .build
        }
    }

    implicit val decoder: Decoder[IngressBackend] = new Decoder[IngressBackend] {
      def apply[T : Reader](t: T): Either[String, IngressBackend] = for {
          obj <- ObjectReader(t)
          resource <- obj.readOpt[io.k8s.api.core.v1.TypedLocalObjectReference]("resource")
          service <- obj.readOpt[io.k8s.api.networking.v1.IngressServiceBackend]("service")
      } yield IngressBackend (
          resource = resource,
          service = service
        )
    }
}

