package io.k8s.api.flowcontrol.v1beta2

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** PriorityLevelConfigurationList is a list of PriorityLevelConfiguration objects. */
final case class PriorityLevelConfigurationList(
  items : Seq[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfiguration],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("flowcontrol.apiserver.k8s.io", "PriorityLevelConfigurationList", "v1beta2")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfiguration]) : PriorityLevelConfigurationList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfiguration*) : PriorityLevelConfigurationList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfiguration] => Seq[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfiguration]) : PriorityLevelConfigurationList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PriorityLevelConfigurationList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PriorityLevelConfigurationList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = PriorityLevelConfigurationList.encoder.apply(this)
}

object PriorityLevelConfigurationList {

    implicit val encoder : Encoder[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationList] = new Encoder[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationList] {
        def apply[T : Builder](o: io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[PriorityLevelConfigurationList] = new Decoder[PriorityLevelConfigurationList] {
      def apply[T : Reader](t: T): Either[String, PriorityLevelConfigurationList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfiguration]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield PriorityLevelConfigurationList (
          items = items,
          metadata = metadata
        )
    }
}

