package io.k8s.api.events.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** Event is a report of an event somewhere in the cluster. It generally denotes some state change in the system. Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data. */
final case class Event(
  eventTime : io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime,
  regarding : Option[io.k8s.api.core.v1.ObjectReference] = None,
  series : Option[io.k8s.api.events.v1.EventSeries] = None,
  reason : Option[String] = None,
  deprecatedCount : Option[Int] = None,
  related : Option[io.k8s.api.core.v1.ObjectReference] = None,
  deprecatedFirstTimestamp : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  note : Option[String] = None,
  reportingController : Option[String] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  deprecatedSource : Option[io.k8s.api.core.v1.EventSource] = None,
  `type` : Option[String] = None,
  deprecatedLastTimestamp : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  reportingInstance : Option[String] = None,
  action : Option[String] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("events.k8s.io", "Event", "v1")


  /** Returns a new data with eventTime set to new value */
  def withEventTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : Event = copy(eventTime = value)
  /** transforms eventTime to result of function */
  def mapEventTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime => io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : Event = copy(eventTime = f(eventTime))

  /** Returns a new data with regarding set to new value */
  def withRegarding(value: io.k8s.api.core.v1.ObjectReference) : Event = copy(regarding = Some(value))
  /** if regarding has a value, transforms to the result of function*/
  def mapRegarding(f: io.k8s.api.core.v1.ObjectReference => io.k8s.api.core.v1.ObjectReference) : Event = copy(regarding = regarding.map(f))

  /** Returns a new data with series set to new value */
  def withSeries(value: io.k8s.api.events.v1.EventSeries) : Event = copy(series = Some(value))
  /** if series has a value, transforms to the result of function*/
  def mapSeries(f: io.k8s.api.events.v1.EventSeries => io.k8s.api.events.v1.EventSeries) : Event = copy(series = series.map(f))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : Event = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : Event = copy(reason = reason.map(f))

  /** Returns a new data with deprecatedCount set to new value */
  def withDeprecatedCount(value: Int) : Event = copy(deprecatedCount = Some(value))
  /** if deprecatedCount has a value, transforms to the result of function*/
  def mapDeprecatedCount(f: Int => Int) : Event = copy(deprecatedCount = deprecatedCount.map(f))

  /** Returns a new data with related set to new value */
  def withRelated(value: io.k8s.api.core.v1.ObjectReference) : Event = copy(related = Some(value))
  /** if related has a value, transforms to the result of function*/
  def mapRelated(f: io.k8s.api.core.v1.ObjectReference => io.k8s.api.core.v1.ObjectReference) : Event = copy(related = related.map(f))

  /** Returns a new data with deprecatedFirstTimestamp set to new value */
  def withDeprecatedFirstTimestamp(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Event = copy(deprecatedFirstTimestamp = Some(value))
  /** if deprecatedFirstTimestamp has a value, transforms to the result of function*/
  def mapDeprecatedFirstTimestamp(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Event = copy(deprecatedFirstTimestamp = deprecatedFirstTimestamp.map(f))

  /** Returns a new data with note set to new value */
  def withNote(value: String) : Event = copy(note = Some(value))
  /** if note has a value, transforms to the result of function*/
  def mapNote(f: String => String) : Event = copy(note = note.map(f))

  /** Returns a new data with reportingController set to new value */
  def withReportingController(value: String) : Event = copy(reportingController = Some(value))
  /** if reportingController has a value, transforms to the result of function*/
  def mapReportingController(f: String => String) : Event = copy(reportingController = reportingController.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Event = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Event = copy(metadata = metadata.map(f))

  /** Returns a new data with deprecatedSource set to new value */
  def withDeprecatedSource(value: io.k8s.api.core.v1.EventSource) : Event = copy(deprecatedSource = Some(value))
  /** if deprecatedSource has a value, transforms to the result of function*/
  def mapDeprecatedSource(f: io.k8s.api.core.v1.EventSource => io.k8s.api.core.v1.EventSource) : Event = copy(deprecatedSource = deprecatedSource.map(f))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : Event = copy(`type` = Some(value))
  /** if `type` has a value, transforms to the result of function*/
  def mapType(f: String => String) : Event = copy(`type` = `type`.map(f))

  /** Returns a new data with deprecatedLastTimestamp set to new value */
  def withDeprecatedLastTimestamp(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Event = copy(deprecatedLastTimestamp = Some(value))
  /** if deprecatedLastTimestamp has a value, transforms to the result of function*/
  def mapDeprecatedLastTimestamp(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Event = copy(deprecatedLastTimestamp = deprecatedLastTimestamp.map(f))

  /** Returns a new data with reportingInstance set to new value */
  def withReportingInstance(value: String) : Event = copy(reportingInstance = Some(value))
  /** if reportingInstance has a value, transforms to the result of function*/
  def mapReportingInstance(f: String => String) : Event = copy(reportingInstance = reportingInstance.map(f))

  /** Returns a new data with action set to new value */
  def withAction(value: String) : Event = copy(action = Some(value))
  /** if action has a value, transforms to the result of function*/
  def mapAction(f: String => String) : Event = copy(action = action.map(f))

  override def foldTo[T : Builder] : T = Event.encoder.apply(this)
}

object Event {

    implicit val encoder : Encoder[io.k8s.api.events.v1.Event] = new Encoder[io.k8s.api.events.v1.Event] {
        def apply[T : Builder](o: io.k8s.api.events.v1.Event) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("eventTime", o.eventTime)
            .write("regarding", o.regarding)
            .write("series", o.series)
            .write("reason", o.reason)
            .write("deprecatedCount", o.deprecatedCount)
            .write("related", o.related)
            .write("deprecatedFirstTimestamp", o.deprecatedFirstTimestamp)
            .write("note", o.note)
            .write("reportingController", o.reportingController)
            .write("metadata", o.metadata)
            .write("deprecatedSource", o.deprecatedSource)
            .write("type", o.`type`)
            .write("deprecatedLastTimestamp", o.deprecatedLastTimestamp)
            .write("reportingInstance", o.reportingInstance)
            .write("action", o.action)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[Event] = new Decoder[Event] {
      def apply[T : Reader](t: T): Either[String, Event] = for {
          obj <- ObjectReader(t)
          eventTime <- obj.read[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime]("eventTime")
          regarding <- obj.readOpt[io.k8s.api.core.v1.ObjectReference]("regarding")
          series <- obj.readOpt[io.k8s.api.events.v1.EventSeries]("series")
          reason <- obj.readOpt[String]("reason")
          deprecatedCount <- obj.readOpt[Int]("deprecatedCount")
          related <- obj.readOpt[io.k8s.api.core.v1.ObjectReference]("related")
          deprecatedFirstTimestamp <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("deprecatedFirstTimestamp")
          note <- obj.readOpt[String]("note")
          reportingController <- obj.readOpt[String]("reportingController")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
          deprecatedSource <- obj.readOpt[io.k8s.api.core.v1.EventSource]("deprecatedSource")
          `type` <- obj.readOpt[String]("type")
          deprecatedLastTimestamp <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("deprecatedLastTimestamp")
          reportingInstance <- obj.readOpt[String]("reportingInstance")
          action <- obj.readOpt[String]("action")
      } yield Event (
          eventTime = eventTime,
          regarding = regarding,
          series = series,
          reason = reason,
          deprecatedCount = deprecatedCount,
          related = related,
          deprecatedFirstTimestamp = deprecatedFirstTimestamp,
          note = note,
          reportingController = reportingController,
          metadata = metadata,
          deprecatedSource = deprecatedSource,
          `type` = `type`,
          deprecatedLastTimestamp = deprecatedLastTimestamp,
          reportingInstance = reportingInstance,
          action = action
        )
    }
}

