package io.k8s.api.core.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** PodTemplateList is a list of PodTemplates. */
final case class PodTemplateList(
  items : Seq[io.k8s.api.core.v1.PodTemplate],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "PodTemplateList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.core.v1.PodTemplate]) : PodTemplateList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.core.v1.PodTemplate*) : PodTemplateList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.core.v1.PodTemplate] => Seq[io.k8s.api.core.v1.PodTemplate]) : PodTemplateList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PodTemplateList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PodTemplateList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = PodTemplateList.encoder.apply(this)
}

object PodTemplateList {

    implicit val encoder : Encoder[io.k8s.api.core.v1.PodTemplateList] = new Encoder[io.k8s.api.core.v1.PodTemplateList] {
        def apply[T : Builder](o: io.k8s.api.core.v1.PodTemplateList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[PodTemplateList] = new Decoder[PodTemplateList] {
      def apply[T : Reader](t: T): Either[String, PodTemplateList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.core.v1.PodTemplate]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield PodTemplateList (
          items = items,
          metadata = metadata
        )
    }
}

