package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** PodOS defines the OS parameters of a pod. */
final case class PodOS(
  name : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : PodOS = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : PodOS = copy(name = f(name))
}

object PodOS {

    implicit val encoder : Encoder[io.k8s.api.core.v1.PodOS] = new Encoder[io.k8s.api.core.v1.PodOS] {
        def apply[T : Builder](o: io.k8s.api.core.v1.PodOS) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .build
        }
    }

    implicit val decoder: Decoder[PodOS] = new Decoder[PodOS] {
      def apply[T : Reader](t: T): Either[String, PodOS] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
      } yield PodOS (
          name = name
        )
    }
}

