package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** NodeConfigStatus describes the status of the config assigned by Node.Spec.ConfigSource. */
final case class NodeConfigStatus(
  active : Option[io.k8s.api.core.v1.NodeConfigSource] = None,
  assigned : Option[io.k8s.api.core.v1.NodeConfigSource] = None,
  error : Option[String] = None,
  lastKnownGood : Option[io.k8s.api.core.v1.NodeConfigSource] = None
) {

  /** Returns a new data with active set to new value */
  def withActive(value: io.k8s.api.core.v1.NodeConfigSource) : NodeConfigStatus = copy(active = Some(value))
  /** if active has a value, transforms to the result of function*/
  def mapActive(f: io.k8s.api.core.v1.NodeConfigSource => io.k8s.api.core.v1.NodeConfigSource) : NodeConfigStatus = copy(active = active.map(f))

  /** Returns a new data with assigned set to new value */
  def withAssigned(value: io.k8s.api.core.v1.NodeConfigSource) : NodeConfigStatus = copy(assigned = Some(value))
  /** if assigned has a value, transforms to the result of function*/
  def mapAssigned(f: io.k8s.api.core.v1.NodeConfigSource => io.k8s.api.core.v1.NodeConfigSource) : NodeConfigStatus = copy(assigned = assigned.map(f))

  /** Returns a new data with error set to new value */
  def withError(value: String) : NodeConfigStatus = copy(error = Some(value))
  /** if error has a value, transforms to the result of function*/
  def mapError(f: String => String) : NodeConfigStatus = copy(error = error.map(f))

  /** Returns a new data with lastKnownGood set to new value */
  def withLastKnownGood(value: io.k8s.api.core.v1.NodeConfigSource) : NodeConfigStatus = copy(lastKnownGood = Some(value))
  /** if lastKnownGood has a value, transforms to the result of function*/
  def mapLastKnownGood(f: io.k8s.api.core.v1.NodeConfigSource => io.k8s.api.core.v1.NodeConfigSource) : NodeConfigStatus = copy(lastKnownGood = lastKnownGood.map(f))
}

object NodeConfigStatus {

    implicit val encoder : Encoder[io.k8s.api.core.v1.NodeConfigStatus] = new Encoder[io.k8s.api.core.v1.NodeConfigStatus] {
        def apply[T : Builder](o: io.k8s.api.core.v1.NodeConfigStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("active", o.active)
            .write("assigned", o.assigned)
            .write("error", o.error)
            .write("lastKnownGood", o.lastKnownGood)
            .build
        }
    }

    implicit val decoder: Decoder[NodeConfigStatus] = new Decoder[NodeConfigStatus] {
      def apply[T : Reader](t: T): Either[String, NodeConfigStatus] = for {
          obj <- ObjectReader(t)
          active <- obj.readOpt[io.k8s.api.core.v1.NodeConfigSource]("active")
          assigned <- obj.readOpt[io.k8s.api.core.v1.NodeConfigSource]("assigned")
          error <- obj.readOpt[String]("error")
          lastKnownGood <- obj.readOpt[io.k8s.api.core.v1.NodeConfigSource]("lastKnownGood")
      } yield NodeConfigStatus (
          active = active,
          assigned = assigned,
          error = error,
          lastKnownGood = lastKnownGood
        )
    }
}

