package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** LimitRangeSpec defines a min/max usage limit for resources that match on kind. */
final case class LimitRangeSpec(
  limits : Seq[io.k8s.api.core.v1.LimitRangeItem]
) {

  /** Returns a new data with limits set to new value */
  def withLimits(value: Seq[io.k8s.api.core.v1.LimitRangeItem]) : LimitRangeSpec = copy(limits = value)
  /** Appends new values to limits */
  def addLimits(newValues: io.k8s.api.core.v1.LimitRangeItem*) : LimitRangeSpec = copy(limits = limits ++ newValues)
  /** transforms limits to result of function */
  def mapLimits(f: Seq[io.k8s.api.core.v1.LimitRangeItem] => Seq[io.k8s.api.core.v1.LimitRangeItem]) : LimitRangeSpec = copy(limits = f(limits))
}

object LimitRangeSpec {

    implicit val encoder : Encoder[io.k8s.api.core.v1.LimitRangeSpec] = new Encoder[io.k8s.api.core.v1.LimitRangeSpec] {
        def apply[T : Builder](o: io.k8s.api.core.v1.LimitRangeSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("limits", o.limits)
            .build
        }
    }

    implicit val decoder: Decoder[LimitRangeSpec] = new Decoder[LimitRangeSpec] {
      def apply[T : Reader](t: T): Either[String, LimitRangeSpec] = for {
          obj <- ObjectReader(t)
          limits <- obj.read[Seq[io.k8s.api.core.v1.LimitRangeItem]]("limits")
      } yield LimitRangeSpec (
          limits = limits
        )
    }
}

